/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.AbstractLandingPageDocument;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.GeoServerOpenAPI;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.IOUtils;

public class OpenAPIBuilder<T extends ServiceInfo> {
    private final String apiSpecification;
    private final String defaultTitle;
    private final APIService serviceAnnotation;

    public OpenAPIBuilder(Class<?> clazz, String location, String defaultTitle, Class serviceClass) {
        try (InputStream is = clazz.getResourceAsStream(location);){
            if (is == null) {
                throw new RuntimeException("Could not find API definition at " + location + " from class " + clazz);
            }
            this.apiSpecification = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the api template", e);
        }
        this.defaultTitle = defaultTitle;
        this.serviceAnnotation = APIDispatcher.getApiServiceAnnotation(serviceClass);
    }

    public OpenAPI build(T service) throws IOException {
        GeoServerOpenAPI api = this.readTemplate();
        api.setServiceBase(this.serviceAnnotation.landingPage());
        this.addAPIInfo(service, api);
        this.addServers(api);
        this.addBasePathFormats(api);
        return api;
    }

    protected void addBasePathFormats(OpenAPI api) {
        this.declareGetResponseFormats(api, "/", this.getLandingPageDocumentClass());
        this.declareGetResponseFormats(api, "/conformance", ConformanceDocument.class);
    }

    protected Class<? extends AbstractLandingPageDocument> getLandingPageDocumentClass() {
        return AbstractLandingPageDocument.class;
    }

    public void addServers(OpenAPI api) {
        String wfsUrl = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)this.serviceAnnotation.landingPage(), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        api.servers(Arrays.asList(new Server().description("This server").url(wfsUrl)));
    }

    public void addAPIInfo(T service, OpenAPI api) {
        ContactInfo contactInfo = service.getGeoServer().getGlobal().getSettings().getContact();
        Contact contact = new Contact().email(contactInfo.getContactEmail()).name(Stream.of(contactInfo.getContactPerson(), contactInfo.getContactOrganization()).filter(s -> s != null).collect(Collectors.joining(" - "))).url(contactInfo.getOnlineResource());
        String title = service.getTitle() == null ? this.defaultTitle : service.getTitle();
        Info info = new Info().contact(contact).title(title).description(service.getAbstract()).version(this.serviceAnnotation.version());
        api.info(info);
    }

    protected void declareGetResponseFormats(OpenAPI api, String path, Class<?> binding) {
        PathItem pi = (PathItem)api.getPaths().get((Object)path);
        Operation get = pi.getGet();
        ApiResponse okResponse = (ApiResponse)get.getResponses().get((Object)"200");
        Content content = new Content();
        okResponse.setContent(content);
        List formats = APIRequestInfo.get().getProducibleMediaTypes(binding, true).stream().map(mt -> mt.toString()).collect(Collectors.toList());
        for (String format : formats) {
            MediaType mediaType = new MediaType();
            if (format.contains("yaml") && content.get((Object)"application/json") != null) {
                mediaType.schema(((MediaType)content.get((Object)"application/json")).getSchema());
            } else if (format.contains("text")) {
                mediaType.schema((Schema)new StringSchema());
            } else {
                mediaType.schema((Schema)new BinarySchema());
            }
            content.addMediaType(format, mediaType);
        }
    }

    protected GeoServerOpenAPI readTemplate() {
        try {
            return (GeoServerOpenAPI)((Object)Yaml.mapper().readValue(this.apiSpecification, GeoServerOpenAPI.class));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

