/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.PaginationLinksBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class PaginationLinksBuilderTest {
    public static final String PATH = "service/v1/resource";
    public static final String URL_BASE = "http://localhost/service/v1/resource";

    @BeforeClass
    public static void setupRequestInfo() {
        RequestAttributes attributes = (RequestAttributes)EasyMock.niceMock(RequestAttributes.class);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        APIRequestInfo requestInfo = new APIRequestInfo((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), (APIDispatcher)EasyMock.mock(APIDispatcher.class));
        APIRequestInfo.set((APIRequestInfo)requestInfo);
        EasyMock.expect((Object)attributes.getAttribute("APIRequestInfo", 0)).andReturn((Object)requestInfo).anyTimes();
        EasyMock.replay((Object[])new Object[]{attributes});
    }

    @Test
    public void testFirst() {
        PaginationLinksBuilder builder = new PaginationLinksBuilder(PATH, 0L, 5, 5, 250L);
        Assert.assertNull((Object)builder.getPrevious());
        Assert.assertEquals((Object)"http://localhost/service/v1/resource?startIndex=5&limit=5", (Object)builder.getNext());
    }

    @Test
    public void testMid() {
        PaginationLinksBuilder builder = new PaginationLinksBuilder(PATH, 5L, 5, 5, 250L);
        Assert.assertEquals((Object)"http://localhost/service/v1/resource?startIndex=0&limit=5", (Object)builder.getPrevious());
        Assert.assertEquals((Object)"http://localhost/service/v1/resource?startIndex=10&limit=5", (Object)builder.getNext());
    }

    @Test
    public void testLast() {
        PaginationLinksBuilder builder = new PaginationLinksBuilder(PATH, 245L, 5, 5, 250L);
        Assert.assertEquals((Object)"http://localhost/service/v1/resource?startIndex=240&limit=5", (Object)builder.getPrevious());
        Assert.assertNull((Object)builder.getNext());
    }
}

