/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.Serializable;
import java.util.Objects;

public class APIConformance
implements Serializable {
    private final APIConformance parent;
    private final String id;
    private final Level level;
    private final Type type;
    private final String property;

    public APIConformance(String id) {
        this(id, Level.STANDARD);
    }

    public APIConformance(String id, Level level) {
        this(id, level, Type.EXTENSION, null);
    }

    public APIConformance(String id, Level level, String property) {
        this(id, level, Type.EXTENSION, null, property);
    }

    public APIConformance(String id, Level level, Type type, APIConformance parent) {
        this(id, level, type, parent, id.substring(id.lastIndexOf(47) + 1));
    }

    public APIConformance(String id, Level level, Type type, APIConformance parent, String property) {
        this.id = id;
        this.level = level;
        this.type = type;
        this.parent = parent;
        this.property = property;
    }

    public APIConformance extend(String id) {
        return new APIConformance(id, Level.STANDARD, Type.EXTENSION, this);
    }

    public APIConformance extend(String id, Level level) {
        return new APIConformance(id, level, Type.EXTENSION, this);
    }

    public String getId() {
        return this.id;
    }

    public String getProperty() {
        return this.property;
    }

    public Level getLevel() {
        return this.level;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIConformance serviceModule = (APIConformance)o;
        return Objects.equals(this.id, serviceModule.id);
    }

    public String toString() {
        return "APIConformance " + this.property + " ( " + this.id + " " + this.level + " )";
    }

    public static enum Type {
        CORE,
        EXTENSION;

    }

    public static enum Level {
        COMMUNITY_DRAFT(false, false),
        COMMUNITY_STANDARD(true, false),
        DRAFT_STANDARD(false, true),
        IMPLEMENTING(false, true),
        STANDARD(true, true),
        RETIRED_STANDARD(true, false);

        private final boolean endorsed;
        private final boolean stable;

        private Level(boolean stable, boolean endorsed) {
            this.endorsed = endorsed;
            this.stable = stable;
        }

        public boolean isEndorsed() {
            return this.endorsed;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

