/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ogcapi.AttributeType;
import org.geoserver.ogcapi.Queryables;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.feature.FeatureTypes;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class QueryablesBuilder {
    public static final String POINT = "Point";
    public static final String MULTIPOINT = "MultiPoint";
    public static final String LINESTRING = "LineString";
    public static final String MULTILINESTRING = "MultiLineString";
    public static final String POLYGON = "Polygon";
    public static final String MULTIPOLYGON = "MultiPolygon";
    public static final String GENERIC_GEOMETRY = "Any geometry";
    public static final String DATE = "Date";
    public static final String DATE_TIME = "DateTime";
    public static final String TIME = "Time";
    Queryables queryables;

    public QueryablesBuilder(String id) {
        this.queryables = new Queryables(id);
        this.queryables.setType("object");
    }

    public QueryablesBuilder forType(FeatureTypeInfo ft) throws IOException {
        this.queryables.setCollectionId(ft.prefixedName());
        this.queryables.setTitle(Optional.ofNullable(ft.getTitle()).orElse(ft.prefixedName()));
        this.queryables.setDescription(ft.getDescription());
        return this.forType(ft.getFeatureType());
    }

    public QueryablesBuilder forType(FeatureType ft) {
        Map properties = ft.getDescriptors().stream().filter(ad -> !ad.getName().equals((Object)ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME)).collect(Collectors.toMap(ad -> ad.getName().getLocalPart(), ad -> this.getSchema((PropertyDescriptor)ad), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, () -> new LinkedHashMap()));
        this.queryables.setProperties(properties);
        return this;
    }

    private Schema<?> getSchema(PropertyDescriptor descriptor) {
        Class binding = descriptor.getType().getBinding();
        Schema<?> schema = QueryablesBuilder.getSchema(binding);
        int fieldLength = FeatureTypes.getFieldLength((PropertyDescriptor)descriptor);
        if (fieldLength != -1) {
            schema.setMaxLength(Integer.valueOf(fieldLength));
        }
        return schema;
    }

    public static Schema<?> getSchema(Class<?> binding) {
        if (Geometry.class.isAssignableFrom(binding)) {
            return QueryablesBuilder.getGeometrySchema(binding);
        }
        return QueryablesBuilder.getAlphanumericSchema(binding);
    }

    private static Schema<?> getGeometrySchema(Class<?> binding) {
        Schema schema = new Schema();
        String title = Point.class.isAssignableFrom(binding) ? POINT : (MultiPoint.class.isAssignableFrom(binding) ? MULTIPOINT : (LineString.class.isAssignableFrom(binding) ? LINESTRING : (MultiLineString.class.isAssignableFrom(binding) ? MULTILINESTRING : (Polygon.class.isAssignableFrom(binding) ? POLYGON : (MultiPolygon.class.isAssignableFrom(binding) ? MULTIPOLYGON : GENERIC_GEOMETRY)))));
        schema.setTitle(title);
        if (title.equals(GENERIC_GEOMETRY)) {
            schema.setFormat("geometry-any");
        } else {
            schema.setFormat("geometry-" + title.toLowerCase());
        }
        return schema;
    }

    public static Schema<?> getAlphanumericSchema(Class<?> binding) {
        if (binding.isEnum()) {
            Schema schema = new Schema();
            schema.setType("string");
            schema.setTitle("string");
            Arrays.stream(binding.getEnumConstants()).map(Object::toString).forEach(n -> schema.addEnumItemObject(n));
            return schema;
        }
        Schema schema = new Schema();
        schema.setType(AttributeType.fromClass(binding).getType());
        schema.setTitle(schema.getType());
        if (Date.class.isAssignableFrom(binding)) {
            schema.setFormat("date");
            schema.setTitle(DATE);
        } else if (Time.class.isAssignableFrom(binding)) {
            schema.setFormat("time");
            schema.setTitle(TIME);
        } else if (java.util.Date.class.isAssignableFrom(binding)) {
            schema.setFormat("date-time");
            schema.setTitle(DATE_TIME);
        } else if (UUID.class.isAssignableFrom(binding)) {
            schema.setFormat("uuid");
        } else if (URL.class.isAssignableFrom(binding)) {
            schema.setTitle("uri");
        } else if (binding.isAssignableFrom(String.class)) {
            schema.setFormat("string");
        } else if (binding.isAssignableFrom(Boolean.class)) {
            schema.setFormat("boolean");
        } else if (binding.isAssignableFrom(Number.class)) {
            schema.setFormat("number");
        }
        return schema;
    }

    public Queryables build() {
        return this.queryables;
    }
}

