/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.google.common.collect.Iterators;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FeatureIteratorIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

@RunWith(value=Parameterized.class)
public class CollectionDocumentBoundsTest
extends FeaturesTestSupport {
    static QName TIGER_POI = new QName("http://www.census.gov", "poi", "tiger");
    static QName TIGER_SINGLE_POI = new QName("http://www.census.gov", "single_poi", "tiger");
    static final List<QName> layersFixture = List.of(TIGER_POI, TIGER_SINGLE_POI, CiteTestData.BUILDINGS);
    private String collectionId;
    private int numDecimals;
    private ReferencedEnvelope latLonBbox;

    public CollectionDocumentBoundsTest(String collectionId, int numDecimals) {
        this.collectionId = collectionId;
        this.numDecimals = numDecimals;
    }

    @Parameterized.Parameters(name="{0}: numDecimals: {1}")
    public static Collection<Object[]> data() {
        return layersFixture.stream().map(qn -> String.format("%s:%s", qn.getPrefix(), qn.getLocalPart())).map(CollectionDocumentBoundsTest::testParams).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<Object[]> testParams(String name) {
        return IntStream.rangeClosed(3, 15).boxed().sorted(Comparator.naturalOrder().reversed()).map(numDecimals -> new Object[]{name, numDecimals}).collect(Collectors.toList());
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        this.addFeatureTypes(testData, catalog);
        layersFixture.stream().map(x$0 -> super.getLayerId(x$0)).forEach(this::adjustFeatureType);
    }

    @Before
    public void beforeEach() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        global.getSettings().setNumDecimals(this.numDecimals);
        geoServer.save(global);
        FeatureTypeInfo featureType = this.getCatalog().getFeatureTypeByName(this.collectionId);
        this.latLonBbox = featureType.getLatLonBoundingBox();
    }

    @Test
    public void testCollectionBoundsCoversActualBounds() throws Exception {
        Assert.assertEquals((long)this.numDecimals, (long)this.getGeoServer().getGlobal().getSettings().getNumDecimals());
        String collectionQuery = String.format("ogc/features/v1/collections/%s", this.collectionId);
        DocumentContext json = this.getAsJSONPath(collectionQuery, 200);
        ReferencedEnvelope actualBounds = this.latLonBbox;
        ReferencedEnvelope encodedBounds = this.parseSpatialExtent(json);
        this.assertMaxDecimals(encodedBounds, this.numDecimals);
        this.assertEncodedCollectionBoundsCoversActualBounds(actualBounds, encodedBounds);
    }

    @Test
    public void testCollectionBoundsCoversItems() throws Exception {
        SimpleFeature[] features;
        Assert.assertEquals((long)this.numDecimals, (long)this.getGeoServer().getGlobal().getSettings().getNumDecimals());
        String collectionQuery = String.format("ogc/features/v1/collections/%s", this.collectionId);
        DocumentContext json = this.getAsJSONPath(collectionQuery, 200);
        ReferencedEnvelope collectionBounds = this.parseSpatialExtent(json);
        String itemsQuery = String.format("ogc/features/v1/collections/%s/items", this.collectionId);
        String fc = super.getAsString(itemsQuery);
        SimpleFeatureCollection parsedFc = GeoJSONReader.parseFeatureCollection((String)fc);
        for (SimpleFeature feature : features = (SimpleFeature[])Iterators.toArray((Iterator)new FeatureIteratorIterator((FeatureIterator)parsedFc.features()), SimpleFeature.class)) {
            this.assertMaxDecimals(feature, this.numDecimals);
            this.assertEncodedCollectionBoundsCoversFeature(feature, collectionBounds);
        }
    }

    private void assertMaxDecimals(SimpleFeature feature, int numDecimals) {
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        if (geom == null) {
            Assert.assertTrue((boolean)true);
        } else {
            Coordinate[] coordinates;
            String strgeom = geom.toText();
            for (Coordinate c : coordinates = geom.getCoordinates()) {
                this.assertMaxDecimals(c.getX(), numDecimals, strgeom);
                this.assertMaxDecimals(c.getY(), numDecimals, strgeom);
            }
        }
    }

    private void assertMaxDecimals(ReferencedEnvelope bounds, int numDecimals) {
        String strbounds = bounds.toString();
        this.assertMaxDecimals(bounds.getMinX(), numDecimals, strbounds);
        this.assertMaxDecimals(bounds.getMaxX(), numDecimals, strbounds);
        this.assertMaxDecimals(bounds.getMinY(), numDecimals, strbounds);
        this.assertMaxDecimals(bounds.getMaxY(), numDecimals, strbounds);
    }

    private void assertMaxDecimals(double ordinate, int numDecimals, String message) {
        int numberOfDecimals = CollectionDocumentBoundsTest.getNumberOfDecimals(ordinate);
        MatcherAssert.assertThat((String)message, (Object)numberOfDecimals, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(numDecimals)));
    }

    private void assertEncodedCollectionBoundsCoversActualBounds(ReferencedEnvelope original, ReferencedEnvelope encoded) {
        String msg = String.format("Expected encoded collection bounds %s to fully contain %s%nencoded extent:\t\t%s %noriginal extent:\t%s", encoded, original, CollectionDocumentBoundsTest.poly((BoundingBox)encoded), CollectionDocumentBoundsTest.poly((BoundingBox)original));
        Assert.assertTrue((String)msg, (boolean)encoded.contains(original));
    }

    private void assertEncodedCollectionBoundsCoversFeature(SimpleFeature feature, ReferencedEnvelope encodedCollectionBounds) {
        ReferencedEnvelope actualCollectionBounds = this.latLonBbox;
        String fid = feature.getID();
        BoundingBox featureBounds = feature.getBounds();
        String msg = String.format("Feature %s bounds not covered by collection bounds%nfeature bounds:\t\t%s %ncollection bounds:\t%s%nreal collection bounds:\t%s", fid, CollectionDocumentBoundsTest.poly(featureBounds), CollectionDocumentBoundsTest.poly((BoundingBox)encodedCollectionBounds), CollectionDocumentBoundsTest.poly((BoundingBox)actualCollectionBounds));
        Assert.assertTrue((String)msg, (boolean)encodedCollectionBounds.contains(featureBounds));
    }

    private static Polygon poly(BoundingBox bounds) {
        return JTS.toGeometry((BoundingBox)bounds);
    }

    private void addFeatureTypes(SystemTestData testData, Catalog catalog) throws IOException {
        testData.addWorkspace(TIGER_POI.getPrefix(), TIGER_POI.getNamespaceURI(), catalog);
        testData.addVectorLayer(TIGER_POI, null, "tiger_poi.properties", ((Object)((Object)this)).getClass(), catalog);
        testData.addVectorLayer(TIGER_SINGLE_POI, null, "tiger_single_poi.properties", ((Object)((Object)this)).getClass(), catalog);
    }

    private void adjustFeatureType(String featureTypeName) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo featureType = catalog.getFeatureTypeByName(featureTypeName);
        Assert.assertNotNull((Object)featureType);
        featureType.setNumDecimals(0);
        try {
            new CatalogBuilder(catalog).setupBounds((ResourceInfo)featureType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ReferencedEnvelope actualLatLonBounds = featureType.getLatLonBoundingBox();
        featureType.setLatLonBoundingBox(actualLatLonBounds);
        catalog.save((ResourceInfo)featureType);
    }

    public static int getNumberOfDecimals(double value) {
        BigDecimal bd = BigDecimal.valueOf(value).stripTrailingZeros();
        return Math.max(0, bd.scale());
    }

    private ReferencedEnvelope parseSpatialExtent(DocumentContext json) {
        double minx = (Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0]);
        double miny = (Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0]);
        double maxx = (Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0]);
        double maxy = (Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0]);
        return new ReferencedEnvelope(minx, maxx, miny, maxy, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }
}

