/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;

public class HttpHeaderContentCrsAppender
extends AbstractDispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(HttpHeaderContentCrsAppender.class);
    public static final String CRS_RESPONSE_HEADER = "Content-Crs";

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        if (result instanceof FeaturesResponse) {
            HttpServletResponse httpResponse = request.getHttpResponse();
            FeatureCollectionResponse fcr = ((FeaturesResponse)((Object)result)).getResponse();
            CoordinateReferenceSystem crs = Optional.ofNullable(fcr).map(fct -> (FeatureCollection)fct.getFeatures().get(0)).map(fc -> fc.getSchema()).map(ft -> ft.getCoordinateReferenceSystem()).orElse(null);
            if (crs != null) {
                try {
                    String crsURI = FeatureService.getCRSURI(crs);
                    if (crsURI != null) {
                        httpResponse.addHeader(CRS_RESPONSE_HEADER, "<" + crsURI + ">");
                    }
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.INFO, "Failed to lookup EPSG code of CRS, won't set the Content-Crs header." + crs, e);
                }
            }
        }
        return response;
    }
}

