/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.github.erosb.jsonsKema.FormatValidationPolicy;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonParser;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SchemaLoader;
import com.github.erosb.jsonsKema.ValidationFailure;
import com.github.erosb.jsonsKema.Validator;
import com.github.erosb.jsonsKema.ValidatorConfig;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class FunctionsTest
extends FeaturesTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testSchemaValid() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/features/v1/functions");
        Schema schema = SchemaLoader.forURL((String)"classpath:/org/geoserver/ogcapi/v1/features/functions-schema.yml").load();
        JsonValue functionsJSON = new JsonParser(response.getContentAsString()).parse();
        Validator validator = Validator.create((Schema)schema, (ValidatorConfig)new ValidatorConfig(FormatValidationPolicy.ALWAYS));
        ValidationFailure failure = validator.validate((IJsonValue)functionsJSON);
        Assert.assertNull((Object)failure);
    }

    @Test
    public void testFunctions() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/functions", 200);
        DocumentContext function = this.readSingleContext(json, "functions[?(@.name=='strSubstring')]");
        Assert.assertEquals((Object)"string", (Object)function.read("returns[0]", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)function.read("arguments[0].title", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)this.readSingle(function, "arguments[0].type"));
        Assert.assertEquals((Object)"beginIndex", (Object)function.read("arguments[1].title", new Predicate[0]));
        Assert.assertEquals((Object)"integer", (Object)this.readSingle(function, "arguments[1].type"));
        Assert.assertEquals((Object)"endIndex", (Object)function.read("arguments[2].title", new Predicate[0]));
        Assert.assertEquals((Object)"integer", (Object)this.readSingle(function, "arguments[2].type"));
    }

    @Test
    public void testFunctionsHTML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/features/v1/functions?f=html");
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String normalizedResponse = response.getContentAsString().replaceAll("\r\n", "\n");
        MatcherAssert.assertThat((Object)normalizedResponse, (Matcher)Matchers.containsString((String)"<h3>Area</h3>\n         <ul>\n         <li>Returns: number </li>\n         <li>Arguments:\n         <table class=\"function-table\">\n         <tr><th>Name</th><th>Title</th><th>Type</th></tr>\n            <tr><td>geometry</td><td>geometry</td><td>geometry </td></tr>\n         </table>\n         </li>\n         </ul>"));
    }
}

