/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class JSONFGSchemaTest
extends FeaturesTestSupport {
    @Test
    public void collection() throws Exception {
        this.basicSchemaTest("collection");
    }

    @Test
    public void coordrefsys() throws Exception {
        this.basicSchemaTest("coordrefsys");
    }

    @Test
    public void featuretype() throws Exception {
        this.basicSchemaTest("featuretype");
    }

    @Test
    public void geometry() throws Exception {
        this.basicSchemaTest("geometry");
    }

    @Test
    public void geometryObjects() throws Exception {
        this.basicSchemaTest("geometry-objects");
    }

    @Test
    public void link() throws Exception {
        this.basicSchemaTest("link");
    }

    @Test
    public void place() throws Exception {
        this.basicSchemaTest("place");
    }

    @Test
    public void time() throws Exception {
        this.basicSchemaTest("time");
    }

    public void basicSchemaTest(String schemaId) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/features/v1/collections/cite:Buildings/schemas/fg/" + schemaId + ".json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/schema+json", (Object)response.getContentType());
        String expected = this.getFixture(schemaId);
        Assert.assertEquals((Object)expected, (Object)response.getContentAsString());
    }

    private String getFixture(String schemaId) throws IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("schema/" + schemaId + ".json");){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Test
    public void featureBuildings() throws Exception {
        DocumentContext json = this.basicFeatureChecks(this.getLayerId(MockData.BUILDINGS), "MultiPolygon");
        Assert.assertEquals((Object)"null", (Object)json.read("properties.properties.oneOf[0].type", new Predicate[0]));
        Assert.assertEquals((Object)"object", (Object)json.read("properties.properties.oneOf[1].type", new Predicate[0]));
    }

    @Test
    public void featureLakes() throws Exception {
        DocumentContext json = this.basicFeatureChecks(this.getLayerId(MockData.LAKES), "MultiPolygon");
        Assert.assertEquals((Object)"null", (Object)json.read("properties.properties.oneOf[0].type", new Predicate[0]));
        DocumentContext props = this.readContext(json, "properties.properties.oneOf[1]");
        Assert.assertEquals((Object)"object", (Object)props.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("FID.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("NAME.type", new Predicate[0]));
    }

    @Test
    public void featurePrimitives() throws Exception {
        DocumentContext json = this.basicFeatureChecks(this.getLayerId(MockData.PRIMITIVEGEOFEATURE), "Polygon");
        Assert.assertEquals((Object)"null", (Object)json.read("properties.properties.oneOf[0].type", new Predicate[0]));
        DocumentContext props = this.readContext(json, "properties.properties.oneOf[1]");
        Assert.assertEquals((Object)"object", (Object)props.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("description.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("name.type", new Predicate[0]));
        Assert.assertEquals((Object)"integer", (Object)props.read("intProperty.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("uriProperty.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("dateTimeProperty.type", new Predicate[0]));
        Assert.assertEquals((Object)"date-time", (Object)props.read("dateTimeProperty.format", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)props.read("dateProperty.type", new Predicate[0]));
        Assert.assertEquals((Object)"date", (Object)props.read("dateProperty.format", new Predicate[0]));
        Assert.assertEquals((Object)"number", (Object)props.read("decimalProperty.type", new Predicate[0]));
        Assert.assertEquals((Object)"boolean", (Object)props.read("booleanProperty.type", new Predicate[0]));
    }

    private DocumentContext basicFeatureChecks(String typeName, String geometryType) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/features/v1/collections/" + typeName + "/schemas/fg/feature.json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/schema+json", (Object)response.getContentType());
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"null", (Object)json.read("properties.geometry.oneOf[0].type", new Predicate[0]));
        Assert.assertEquals((Object)("geometry-objects.json#/$defs/" + geometryType), (Object)json.read("properties.geometry.oneOf[1].$ref", new Predicate[0]));
        Assert.assertEquals((Object)"null", (Object)json.read("properties.place.oneOf[0].type", new Predicate[0]));
        Assert.assertEquals((Object)("geometry-objects.json#/$defs/" + geometryType), (Object)json.read("properties.place.oneOf[1].$ref", new Predicate[0]));
        return json;
    }
}

