/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.util.Collections;
import java.util.List;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.SampleDataProvider;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.util.ResponseUtils;
import org.springframework.stereotype.Component;

@Component
public class FeaturesSampleDataProvider
implements SampleDataProvider {
    private final FeatureService service;

    FeaturesSampleDataProvider(FeatureService service) {
        this.service = service;
    }

    public List<Link> getSampleData(LayerInfo layer) {
        if (layer.getResource() instanceof ResourceInfo && this.service.getService().isEnabled()) {
            String resourceId = layer.getResource().prefixedName();
            return APIRequestInfo.get().getLinksFor("ogc/features/v1/collections/" + ResponseUtils.urlEncode((String)resourceId, (char[])new char[0]) + "/items", FeaturesResponse.class, resourceId + " items as ", "data", false, "data", (media, link) -> {
                String href = link.getHref() + "&limit=" + this.service.getService().getMaxNumberOfFeaturesForPreview();
                link.setHref(href);
            });
        }
        return Collections.emptyList();
    }
}

