/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFSInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;

public class CollectionTest
extends FeaturesTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        FeatureTypeInfo basicPolygons = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        basicPolygons.setOverridingServiceSRS(true);
        basicPolygons.getResponseSRS().addAll(Arrays.asList("3857", "32632"));
        this.getCatalog().save((ResourceInfo)basicPolygons);
    }

    @Before
    public void cleanupRoads() throws IOException {
        this.revertLayer(MockData.ROAD_SEGMENTS);
    }

    @Before
    public void resetWFS() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.getSRS().clear();
        wfs.setEnabled(true);
        gs.save((ServiceInfo)wfs);
    }

    @Test
    public void testCollectionJson() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"cite:RoadSegments", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.title", String.class, new Predicate[0]));
        Assert.assertEquals((double)-180.0, (double)((Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)-90.0, (double)((Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)180.0, (double)((Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)90.0, (double)((Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)json.read("$.extent.spatial.crs", String.class, new Predicate[0]));
        List<MediaType> formats = this.getFeaturesResponseFormats();
        MatcherAssert.assertThat((Object)((Integer)json.read("$.links.length()", Integer.class, new Predicate[0])), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(formats.size())));
        for (MediaType mediaType : formats) {
            List items = (List)json.read("$.links[?(@.type=='" + mediaType + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)("cite:RoadSegments items as " + mediaType), item.get("title"));
            Assert.assertEquals((Object)"items", item.get("rel"));
        }
        this.readSingle(json, "links[?(@.type=='application/gml+xml;version=3.2')]");
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, "links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/queryables' && @.type=='application/schema+json')].href")), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite:RoadSegments/queryables?f=application%2Fschema%2Bjson"));
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5000)));
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/IAU/0/1000"}));
        crs.remove("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        for (String c : crs) {
            Assert.assertTrue((String)(c + " is not using the expect CRS URI format"), (boolean)c.matches("http://www.opengis.net/def/crs/[\\w]+/\\d+/\\d+"));
        }
        String string = (String)json.read("storageCrs", new Predicate[0]);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)string);
    }

    @Test
    public void testCollectionJsonCustomCRSList() throws Exception {
        String roadSegments = this.getLayerId(MockData.BASIC_POLYGONS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"cite:BasicPolygons", (Object)json.read("$.id", String.class, new Predicate[0]));
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.contains((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/32632"}));
    }

    @Test
    public void testCustomizeGlobalCRSList() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.getSRS().addAll(Arrays.asList("EPSG:4326", "EPSG:3857"));
        gs.save((ServiceInfo)wfs);
        String polygons = this.getLayerId(MockData.POLYGONS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + polygons, 200);
        Assert.assertEquals((Object)"cgf:Polygons", (Object)json.read("$.id", String.class, new Predicate[0]));
        String storageCrs = (String)json.read("storageCrs", new Predicate[0]);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/EPSG/0/32615", (Object)storageCrs);
        List crs = (List)json.read("crs", new Predicate[0]);
        Assert.assertEquals((long)4L, (long)crs.size());
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/32615"}));
    }

    private List<MediaType> getFeaturesResponseFormats() {
        return ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)applicationContext)).getProducibleMediaTypes(FeaturesResponse.class, true);
    }

    @Test
    public void testCollectionVirtualWorkspace() throws Exception {
        String roadSegments = MockData.ROAD_SEGMENTS.getLocalPart();
        DocumentContext json = this.getAsJSONPath("cite/ogc/features/v1/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.title", String.class, new Predicate[0]));
        List<MediaType> formats = this.getFeaturesResponseFormats();
        MatcherAssert.assertThat((Object)((Integer)json.read("$.links.length()", Integer.class, new Predicate[0])), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(formats.size())));
        for (MediaType format : formats) {
            List items = (List)json.read("$.links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)("RoadSegments items as " + format), item.get("title"));
            Assert.assertEquals((Object)"items", item.get("rel"));
        }
        this.readSingle(json, "$.links[?(@.type=='application/gml+xml;version=3.2')]");
    }

    @Test
    public void testCollectionYaml() throws Exception {
        this.getAsString("ogc/features/v1/collections/" + this.getLayerId(MockData.ROAD_SEGMENTS) + "?f=application/yaml");
    }

    @Test
    public void testCollectionHTMLRemovedInlineJS() throws Exception {
        String html = this.getAsString("ogc/features/v1/collections/" + this.getLayerId(MockData.ROAD_SEGMENTS) + "?f=text/html");
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/common.js\"></script>"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/features.js\"></script>"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<input type=\"hidden\" id=\"maxNumberOfFeaturesForPreview\" value=\"50\"/>"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"form-select-open-basic"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"form-select-open-limit"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"onchange")));
    }

    @Test
    public void testCustomLinks() throws Exception {
        FeatureTypeInfo roads = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.ROAD_SEGMENTS));
        LinkInfoImpl link1 = new LinkInfoImpl("enclosure", "application/geopackage+sqlite3", "http://example.com/roads.gpkg");
        LinkInfoImpl link2 = new LinkInfoImpl("rasterized", "image/tiff", "http://example.com/roads.tif");
        link2.setService("Coverages");
        ArrayList links = Stream.of(link1, link2).collect(Collectors.toCollection(ArrayList::new));
        roads.getMetadata().put("ogcApiLinks", (Serializable)links);
        this.getCatalog().save((ResourceInfo)roads);
        String rsName = MockData.ROAD_SEGMENTS.getLocalPart();
        DocumentContext json = this.getAsJSONPath("cite/ogc/features/v1/collections/" + rsName, 200);
        DocumentContext l1c = this.readSingleContext(json, "$.links[?(@.rel=='enclosure')]");
        Assert.assertEquals((Object)link1.getHref(), (Object)l1c.read("href", new Predicate[0]));
        Assert.assertEquals((Object)link1.getType(), (Object)l1c.read("type", new Predicate[0]));
        List l2List = (List)json.read("$.links[?(@.rel=='rasterized')]", List.class, new Predicate[0]);
        Assert.assertTrue((boolean)l2List.isEmpty());
    }

    @Test
    public void testDescribeFeatureType() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        String resource = "ogc/features/v1/collections/" + roadSegments;
        DocumentContext jsonEnabled = this.getAsJSONPath(resource, 200);
        MatcherAssert.assertThat((Object)((String)this.readSingle(jsonEnabled, "$.links[?(@.rel=='describedBy')].href")), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.startsWith((String)"http://localhost:8080/geoserver/wfs?"), CoreMatchers.containsString((String)"request=DescribeFeatureType"), CoreMatchers.containsString((String)"service=WFS"), CoreMatchers.containsString((String)"version=2.0"), CoreMatchers.containsString((String)"typenames=cite%3ARoadSegments")}));
    }
}

