/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureChainingMockData;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ComplexFeaturesTest
extends AbstractAppSchemaTestSupport {
    protected AbstractAppSchemaMockData createTestData() {
        return new FeatureChainingMockData();
    }

    @Test
    public void testHTMLMappedFeature() throws Exception {
        Document doc = this.getAsJSoup("ogc/features/v1/collections/gsml:MappedFeature/items?f=text/html");
        Assert.assertEquals((long)5L, (long)doc.select("ul[id=rootUL]").size());
        Assert.assertEquals((long)4L, (long)doc.select("li>span:containsOwn(GeologicUnitType)").size());
        Assert.assertEquals((long)6L, (long)doc.select("li>span:containsOwn(CompositionPartType)").size());
    }

    @Test
    public void testHTMLMappedFeatureRemovedInlineJS() throws Exception {
        String html = this.getAsString("ogc/features/v1/collections/gsml:MappedFeature/items?f=text/html");
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/common.js\"></script>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/features.js\"></script>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<script>")));
    }
}

