/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.v1.features.FeatureConformance;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ConformanceTest
extends FeaturesTestSupport {
    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Iterable)json.read("$.conformsTo", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedConformanceClasses()));
    }

    private String[] getExpectedConformanceClasses() {
        return new String[]{FeatureConformance.CORE.getId(), FeatureConformance.OAS30.getId(), FeatureConformance.HTML.getId(), FeatureConformance.GEOJSON.getId(), FeatureConformance.GML321.getId(), FeatureConformance.CRS_BY_REFERENCE.getId(), "http://www.opengis.net/spec/ogcapi-features-3/1.0/conf/features-filter", "http://www.opengis.net/spec/ogcapi-features-3/1.0/conf/filter", "http://www.opengis.net/spec/ogcapi-features-3/1.0/conf/queryables", "http://geoserver.org/spec/ecql/1.0/req/gs-ecql", "http://geoserver.org/spec/ecql/1.0/req/ecql-text", "http://www.opengis.net/spec/cql2/1.0/req/basic-cql2", "http://www.opengis.net/spec/cql2/1.0/req/advanced-comparison-operators", "http://www.opengis.net/spec/cql2/1.0/req/arithmetic", "http://www.opengis.net/spec/cql2/1.0/req/property-property", "http://www.opengis.net/spec/cql2/1.0/req/basic-spatial-operators", "http://www.opengis.net/spec/cql2/1.0/req/spatial-operators", "http://www.opengis.net/spec/cql2/1.0/req/functions", "http://www.opengis.net/spec/cql2/1.0/req/cql2-text"};
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/features/v1/conformance/?f=application/yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/features/v1/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer OGC API Features Conformance", (Object)document.select("#title").text());
        List classes = document.select("#content li").stream().map(e -> e.text()).collect(Collectors.toList());
        MatcherAssert.assertThat(classes, (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedConformanceClasses()));
    }
}

