/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIConformance;
import org.geoserver.ogcapi.ConformanceInfo;
import org.geoserver.wfs.WFSInfo;

public class CQL2Conformance
extends ConformanceInfo<WFSInfo> {
    public static final String METADATA_KEY = "cql2";
    public static final APIConformance CQL2_TEXT = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/cql2-text");
    public static final APIConformance CQL2_JSON = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/cql2-json", APIConformance.Level.DRAFT_STANDARD);
    public static final APIConformance CQL2_ADVANCED = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/advanced-comparison-operators");
    public static final APIConformance CQL2_ARITHMETIC = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/arithmetic");
    public static final APIConformance CQL2_BASIC = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/basic-cql2");
    public static final APIConformance CQL2_BASIC_SPATIAL = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/basic-spatial-operators");
    public static final APIConformance CQL2_FUNCTIONS = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/functions");
    public static final APIConformance CQL2_TEMPORAL = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/temporal-operators");
    public static final APIConformance CQL2_ARRAY = new APIConformance("http://www.opengis.net/spec/ogcapi-features-3/1.0/req/arrays");
    public static final APIConformance CQL2_PROPERTY_PROPERTY = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/property-property");
    public static final APIConformance CQL2_SPATIAL = new APIConformance("http://www.opengis.net/spec/cql2/1.0/req/spatial-operators");
    private Boolean json;
    private Boolean text;
    private Boolean advanced;
    private Boolean arithmetic;
    private Boolean basic;
    private Boolean basicSpatial;
    private Boolean functions;
    private Boolean propertyProperty;
    private Boolean spatial;

    public static CQL2Conformance configuration(WFSInfo wfsInfo) {
        if (wfsInfo.getMetadata().containsKey((Object)METADATA_KEY)) {
            return (CQL2Conformance)((Object)wfsInfo.getMetadata().get((Object)METADATA_KEY));
        }
        CQL2Conformance conf = new CQL2Conformance();
        wfsInfo.getMetadata().put(METADATA_KEY, (Serializable)((Object)conf));
        return conf;
    }

    public boolean isEnabled(WFSInfo info) {
        return this.text(info) || this.json(info);
    }

    public List<APIConformance> conformances(WFSInfo wfsInfo) {
        ArrayList<APIConformance> conformanceList = new ArrayList<APIConformance>();
        if (this.isEnabled(wfsInfo)) {
            if (this.text(wfsInfo)) {
                conformanceList.add(CQL2_TEXT);
            }
            if (this.json(wfsInfo)) {
                conformanceList.add(CQL2_JSON);
            }
            if (this.basic(wfsInfo)) {
                conformanceList.add(CQL2_BASIC);
            }
            if (this.advanced(wfsInfo)) {
                conformanceList.add(CQL2_ADVANCED);
            }
            if (this.arithmetic(wfsInfo)) {
                conformanceList.add(CQL2_ARITHMETIC);
            }
            if (this.propertyProperty(wfsInfo)) {
                conformanceList.add(CQL2_PROPERTY_PROPERTY);
            }
            if (this.basicSpatial(wfsInfo)) {
                conformanceList.add(CQL2_BASIC_SPATIAL);
            }
            if (this.spatial(wfsInfo)) {
                conformanceList.add(CQL2_SPATIAL);
            }
            if (this.functions(wfsInfo)) {
                conformanceList.add(CQL2_FUNCTIONS);
            }
        }
        return conformanceList;
    }

    public Boolean isText() {
        return this.text;
    }

    public void setText(Boolean enabled) {
        this.text = enabled;
    }

    public boolean text(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.text, CQL2_TEXT);
    }

    public Boolean isJSON() {
        return this.json;
    }

    public void setJSON(Boolean enabled) {
        this.json = enabled;
    }

    public boolean json(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.json, CQL2_JSON);
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setCql2Advanced(boolean enabled) {
        this.advanced = enabled;
    }

    public boolean advanced(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.advanced, CQL2_ADVANCED);
    }

    public Boolean isArithmetic() {
        return this.arithmetic;
    }

    public void setArtihmetic(Boolean enabled) {
        this.arithmetic = enabled;
    }

    public boolean arithmetic(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.arithmetic, CQL2_ARITHMETIC);
    }

    public Boolean isBasic() {
        return this.basic;
    }

    public void setBasic(Boolean enabled) {
        this.basic = enabled;
    }

    public boolean basic(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.basic, CQL2_BASIC);
    }

    public Boolean isBasicSpatial() {
        return this.basicSpatial;
    }

    public void setBasicSpatial(Boolean enabled) {
        this.basicSpatial = enabled;
    }

    public boolean basicSpatial(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.basicSpatial, CQL2_BASIC_SPATIAL);
    }

    public Boolean isFunctions() {
        return this.functions;
    }

    public void setFunctions(Boolean enabled) {
        this.functions = enabled;
    }

    public boolean functions(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.functions, CQL2_FUNCTIONS);
    }

    public Boolean isPropertyProperty() {
        return this.propertyProperty;
    }

    public void setPropertyProperty(Boolean enabled) {
        this.propertyProperty = enabled;
    }

    public boolean propertyProperty(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.propertyProperty, CQL2_PROPERTY_PROPERTY);
    }

    public Boolean isSpatial() {
        return this.spatial;
    }

    public void setSpatial(Boolean enabled) {
        this.spatial = enabled;
    }

    public boolean spatial(WFSInfo info) {
        return this.isEnabled((ServiceInfo)info, this.spatial, CQL2_SPATIAL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CQL2Conformance");
        sb.append(" ").append(METADATA_KEY);
        sb.append("{ text=").append(this.text);
        sb.append("{ json=").append(this.json);
        sb.append('}');
        return sb.toString();
    }
}

