/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.geoserver.ogcapi.MessageConverterResponseAdapter;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class FeatureResponseMessageConverter
extends MessageConverterResponseAdapter<FeaturesResponse> {
    static final Logger LOGGER = Logging.getLogger(FeatureResponseMessageConverter.class);
    private static final Version V2 = new Version("2.0");
    List<Response> responses;

    public FeatureResponseMessageConverter() {
        super(FeaturesResponse.class, FeatureCollectionResponse.class);
    }

    protected void writeResponse(FeaturesResponse value, HttpOutputMessage httpOutputMessage, Operation operation, Response response) throws IOException {
        this.setHeaders(value.getResponse(), operation, response, httpOutputMessage);
        response.write((Object)value.getResponse(), httpOutputMessage.getBody(), operation);
    }

    protected Operation getOperation(FeaturesResponse result, Request dr, MediaType mediaType) {
        Operation op = dr.getOperation();
        return new Operation("GetFeature", op.getService(), op.getMethod(), new Object[]{result.getRequest()});
    }

    protected Predicate<Response> getResponseFilterPredicate() {
        return r -> r instanceof WFSGetFeatureOutputFormat && ((WFSGetFeatureOutputFormat)r).canHandle(V2);
    }
}

