/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.v1.features.RFCGeoJSONFeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.TypeInfoCollectionWrapper;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.springframework.stereotype.Component;

@Component(value="JSONFGFeaturesResponse")
public class JSONFGFeaturesResponse
extends RFCGeoJSONFeaturesResponse {
    static final Logger LOGGER = Logging.getLogger(JSONFGFeaturesResponse.class);
    public static final String MIME_TYPE = "application/vnd.ogc.fg+json";
    public static final String COORD_REF_SYS = "coordRefSys";

    public JSONFGFeaturesResponse(GeoServer gs) {
        super(gs, MIME_TYPE);
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return MIME_TYPE;
    }

    @Override
    protected void writeExtraFeatureProperties(Feature feature, Operation operation, GeoJSONBuilder jw) {
        String featureId = this.getItemId();
        if (featureId != null) {
            this.writeCoordRefSys(jw, feature.getType().getCoordinateReferenceSystem());
            this.writeLinks(null, operation, jw, featureId);
        }
    }

    @Override
    protected void writeCollectionCRS(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) throws IOException {
        this.writeCoordRefSys(jsonWriter, crs);
    }

    private void writeCoordRefSys(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) {
        if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs)) {
            jsonWriter.key(COORD_REF_SYS);
            jsonWriter.value((Object)this.getCRSURI(crs));
        }
    }

    private String getCRSURI(CoordinateReferenceSystem crs) {
        try {
            String epsgIdentifier = CRS.lookupIdentifier((Citation)Citations.EPSG, (CoordinateReferenceSystem)crs, (boolean)false);
            if (epsgIdentifier != null) {
                return "http://www.opengis.net/def/crs/EPSG/0/" + epsgIdentifier;
            }
            ReferenceIdentifier identifier = (ReferenceIdentifier)crs.getIdentifiers().iterator().next();
            String authority = identifier.getAuthority().toString();
            String code = identifier.getCode();
            return "http://www.opengis.net/def/crs/" + authority + "/0/" + code;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeGeometry(GeoJSONBuilder jsonWriter, GeometryDescriptor descriptor, Geometry aGeom) {
        boolean otherCRS = descriptor != null && descriptor.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)descriptor.getCoordinateReferenceSystem());
        String key = "geometry";
        if (otherCRS) {
            jsonWriter.setAxisOrder(CRS.AxisOrder.EAST_NORTH);
            key = "place";
        }
        jsonWriter.key(key);
        if (aGeom != null) {
            jsonWriter.writeGeom(aGeom);
        } else {
            jsonWriter.value(null);
        }
    }

    protected void writeExtraCollectionProperties(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw) {
        Integer geometryDimension;
        if (response.getFeatures().size() != 1) {
            return;
        }
        FeatureCollection collection = (FeatureCollection)response.getFeatures().get(0);
        FeatureType schema = collection.getSchema();
        if (schema == null) {
            return;
        }
        jw.key("featureType");
        if (collection instanceof TypeInfoCollectionWrapper) {
            TypeInfoCollectionWrapper wrapper = (TypeInfoCollectionWrapper)collection;
            jw.value((Object)wrapper.getFeatureTypeInfo().prefixedName());
        } else {
            jw.value((Object)schema.getName().getLocalPart());
        }
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        if (gd != null && (geometryDimension = this.getGeometryDimension(gd.getType().getBinding())) != null) {
            jw.key("geometryDimension");
            jw.value((Object)geometryDimension);
        }
    }

    private Integer getGeometryDimension(Class<?> binding) {
        if (Point.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding)) {
            return 0;
        }
        if (LineString.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding)) {
            return 1;
        }
        if (Polygon.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding)) {
            return 2;
        }
        LOGGER.log(Level.WARNING, "Could not compute geometry dimension for " + binding);
        return null;
    }

    @Override
    protected void addLinks(FeatureCollectionResponse response, GetFeatureRequest request, GeoJSONBuilder jw, String featureId, FeatureTypeInfo featureType) {
        String baseUrl = request.getBaseUrl();
        super.addLinks(response, request, jw, featureId, featureType);
        String path = "ogc/features/v1/collections/" + ResponseUtils.urlEncode((String)featureType.prefixedName(), (char[])new char[0]) + "/schemas/fg/";
        path = featureId != null ? path + "feature.json" : path + "collection.json";
        String href = ResponseUtils.buildURL((String)baseUrl, (String)path, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        String linkType = "type";
        String linkTitle = "JSON schema";
        this.writeLink(jw, linkTitle, "application/schema+json", linkType, href);
    }
}

