/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.QueryablesBuilder;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.springframework.http.HttpStatus;

public class JSONFGSchemaBuilder {
    static final ObjectMapper MAPPER = JSONFGSchemaBuilder.getObjectMapper();
    private final FeatureType featureType;
    private final String schemaId;
    private List<Class<?>> KNOWN_GEOMETRY_TYPES = List.of(Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class, GeometryCollection.class);

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public JSONFGSchemaBuilder(FeatureType featureType, String schemaId) {
        this.featureType = featureType;
        this.schemaId = schemaId;
    }

    public String build() throws IOException {
        String schema;
        String fileName = "schema/" + this.schemaId + ".json";
        if (this.getClass().getResource(fileName) == null) {
            throw new APIException("NotFound", "No schema found for " + this.schemaId, HttpStatus.NOT_FOUND);
        }
        try (InputStream is = this.getClass().getResourceAsStream(fileName);){
            schema = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        if (!this.schemaId.equals("feature")) {
            return schema;
        }
        JsonNode root = MAPPER.readTree(schema);
        ObjectNode geometry = (ObjectNode)root.get("properties").get("geometry");
        geometry.removeAll();
        ObjectNode place = (ObjectNode)root.get("properties").get("place");
        place.removeAll();
        if (this.featureType.getGeometryDescriptor() == null) {
            geometry.put("type", "null");
            place.put("type", "null");
        } else {
            Class binding = this.featureType.getGeometryDescriptor().getType().getBinding();
            Optional<String> type = this.KNOWN_GEOMETRY_TYPES.stream().filter(t -> t.isAssignableFrom(binding)).map(t -> t.getSimpleName()).findFirst();
            if (type.isPresent()) {
                JSONFGSchemaBuilder.addSingleGeometryType(geometry, place, type.get());
            } else {
                throw new IllegalArgumentException("Unsupported geometry type " + binding);
            }
        }
        ObjectNode propertiesObject = (ObjectNode)root.get("properties").get("properties").get("oneOf").get(1);
        this.featureType.getDescriptors().stream().filter(d -> !(d instanceof GeometryDescriptor)).forEach(d -> propertiesObject.set(d.getName().getLocalPart(), MAPPER.valueToTree((Object)QueryablesBuilder.getAlphanumericSchema((Class)d.getType().getBinding()))));
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
    }

    private static void addSingleGeometryType(ObjectNode geometry, ObjectNode place, String type) {
        ObjectNode nullType = MAPPER.createObjectNode();
        nullType.put("type", "null");
        ObjectNode refType = MAPPER.createObjectNode();
        refType.put("$ref", "geometry-objects.json#/$defs/" + type);
        ArrayNode values = MAPPER.createArrayNode();
        values.add((JsonNode)nullType);
        values.add((JsonNode)refType);
        geometry.set("oneOf", (JsonNode)values);
        place.set("oneOf", (JsonNode)values);
    }
}

