/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.features.CollectionDocument;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.json.GeoJSONGetFeatureResponse;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component(value="RFCGeoJSONFeaturesResponse")
public class RFCGeoJSONFeaturesResponse
extends GeoJSONGetFeatureResponse {
    @Autowired
    public RFCGeoJSONFeaturesResponse(GeoServer gs) {
        super(gs, "application/geo+json");
    }

    protected RFCGeoJSONFeaturesResponse(GeoServer gs, String mimeType) {
        super(gs, mimeType);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/geo+json";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException {
        if (this.getItemId() != null) {
            this.writeSingleFeature((FeatureCollectionResponse)value, output, operation);
        } else {
            super.write(value, output, operation);
        }
    }

    protected String getItemId() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(att -> (String)att.getAttribute(FeatureService.ITEM_ID, 0)).orElse(null);
    }

    private void writeSingleFeature(FeatureCollectionResponse value, OutputStream output, Operation operation) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(output, this.gs.getGlobal().getSettings().getCharset());
        try (BufferedWriter outWriter = new BufferedWriter(osw);){
            FeatureCollectionResponse featureCollection = value;
            boolean isComplex = RFCGeoJSONFeaturesResponse.isComplexFeature((FeatureCollectionResponse)featureCollection);
            GeoJSONBuilder jsonWriter = this.getGeoJSONBuilder(featureCollection, outWriter);
            this.writeFeatures(featureCollection.getFeatures(), operation, isComplex, jsonWriter);
            outWriter.flush();
        }
    }

    protected void writeExtraFeatureProperties(Feature feature, Operation operation, GeoJSONBuilder jw) {
        String featureId = this.getItemId();
        if (featureId != null) {
            this.writeLinks(null, operation, jw, featureId);
        }
    }

    protected void writePagingLinks(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw) {
        this.writeLinks(response, operation, jw, null);
    }

    protected void writeLinks(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw, String featureId) {
        APIRequestInfo requestInfo = APIRequestInfo.get();
        if (null == requestInfo) {
            return;
        }
        GetFeatureRequest request = GetFeatureRequest.adapt((Object)operation.getParameters()[0]);
        FeatureTypeInfo featureType = this.getFeatureType(request);
        jw.key("links");
        jw.array();
        this.addLinks(response, request, jw, featureId, featureType);
        jw.endArray();
    }

    protected void addLinks(FeatureCollectionResponse response, GetFeatureRequest request, GeoJSONBuilder jw, String featureId, FeatureTypeInfo featureType) {
        String baseUrl = request.getBaseUrl();
        APIRequestInfo requestInfo = APIRequestInfo.get();
        if (response != null) {
            if (response.getPrevious() != null) {
                this.writeLink(jw, "Previous page", "application/geo+json", "prev", response.getPrevious());
            }
            if (response.getNext() != null) {
                this.writeLink(jw, "Next page", "application/geo+json", "next", response.getNext());
            }
        }
        String basePath = "ogc/features/v1/collections/" + ResponseUtils.urlEncode((String)featureType.prefixedName(), (char[])new char[0]);
        Collection formats = requestInfo.getProducibleMediaTypes(FeaturesResponse.class, true);
        for (MediaType format : formats) {
            String path = basePath + "/items";
            if (featureId != null) {
                path = path + "/" + ResponseUtils.urlEncode((String)featureId, (char[])new char[0]);
            }
            String href = ResponseUtils.buildURL((String)baseUrl, (String)path, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType = "alternate";
            Object linkTitle = "This document as " + format;
            if (format.toString().equals("application/geo+json")) {
                linkType = "self";
                linkTitle = "This document";
            }
            this.writeLink(jw, (String)linkTitle, format.toString(), linkType, href);
        }
        for (MediaType format : requestInfo.getProducibleMediaTypes(CollectionDocument.class, true)) {
            String href = ResponseUtils.buildURL((String)baseUrl, (String)basePath, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType = "collection";
            String linkTitle = "The collection description as " + format;
            this.writeLink(jw, linkTitle, format.toString(), linkType, href);
        }
    }

    protected FeatureTypeInfo getFeatureType(GetFeatureRequest request) {
        return Optional.ofNullable(request.getQueries()).filter(qs -> !qs.isEmpty()).map(qs -> (Query)qs.get(0)).map(q -> q.getTypeNames()).filter(tns -> !tns.isEmpty()).map(tns -> (QName)tns.get(0)).map(tn -> new NameImpl(tn.getNamespaceURI(), tn.getLocalPart())).map(tn -> this.gs.getCatalog().getFeatureTypeByName((Name)tn)).orElse(null);
    }

    protected void writeCollectionCRS(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) throws IOException {
        if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs)) {
            super.writeCollectionCRS(jsonWriter, crs);
        }
    }

    protected void writeCollectionCounts(BigInteger featureCount, long numberReturned, GeoJSONBuilder jsonWriter) {
        if (featureCount != null) {
            jsonWriter.key("numberMatched").value((Object)featureCount);
        }
        jsonWriter.key("numberReturned").value(numberReturned);
    }

    protected void writeCollectionBounds(boolean featureBounding, GeoJSONBuilder jsonWriter, List<FeatureCollection> resultsList, boolean hasGeom) {
    }

    public String getCapabilitiesElementName() {
        return "GeoJSON-RFC";
    }

    public boolean canHandle(Operation operation) {
        String operationId = operation.getId();
        if ("GetFeatures".equalsIgnoreCase(operationId) || "GetFeature".equalsIgnoreCase(operationId) || "GetFeatureWithLock".equalsIgnoreCase(operationId) || "getTile".equalsIgnoreCase(operationId)) {
            return operation.getService() != null && "Features".equals(operation.getService().getId());
        }
        return false;
    }
}

