/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.params.extractor.rest.ParamsExtractorRestTestSupport;
import org.geoserver.util.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class EchoesControllerTest
extends ParamsExtractorRestTestSupport {
    @Before
    public void prepareConfiguration() throws IOException {
        GeoServerDataDirectory dd = this.getDataDirectory();
        try (OutputStream os = dd.get(new String[]{EchoParametersDao.getEchoParametersPath()}).out();
             InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/data/echoParameters4.xml");){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    @Test
    public void testGetEchoesListXML() throws Exception {
        Document dom = this.getAsDom("/rest/params-extractor/echoes", "application/xml", 200);
        XMLAssert.assertXpathExists((String)"/EchoParameters", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/EchoParameters/EchoParameter)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/EchoParameters/EchoParameter[1]/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/params-extractor/echoes/0.xml", (String)"/EchoParameters/EchoParameter[1]/atom:link/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/EchoParameters/EchoParameter[2]/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/params-extractor/echoes/1.xml", (String)"/EchoParameters/EchoParameter[2]/atom:link/@href", (Document)dom);
    }

    @Test
    public void testGetEchoesListJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/echoes.json", "application/json", 200);
        JSONObject wrapper = json.getJSONObject("EchoParameters");
        Assert.assertNotNull((Object)wrapper);
        JSONArray array = wrapper.getJSONArray("EchoParameter");
        Assert.assertEquals((long)2L, (long)array.size());
        Assert.assertEquals((Object)0, (Object)array.getJSONObject(0).get("id"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/params-extractor/echoes/0.json", (Object)array.getJSONObject(0).get("href"));
        Assert.assertEquals((Object)1, (Object)array.getJSONObject(1).get("id"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/params-extractor/echoes/1.json", (Object)array.getJSONObject(1).get("href"));
    }

    @Test
    public void testGetEchoXML() throws Exception {
        Document dom = this.getAsDom("/rest/params-extractor/echoes/0", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/EchoParameter)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/EchoParameter/@activated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/EchoParameter/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CQL_FILTER", (String)"/EchoParameter/@parameter", (Document)dom);
    }

    @Test
    public void testGetEchoJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/echoes/0.json", "application/json", 200);
        this.print((JSON)json);
        JSONObject param = json.getJSONObject("EchoParameter");
        Assert.assertEquals((Object)0, (Object)param.get("id"));
        Assert.assertEquals((Object)"CQL_FILTER", (Object)param.get("parameter"));
        Assert.assertEquals((Object)true, (Object)param.get("activated"));
    }

    @Test
    public void testDeleteEcho() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/params-extractor/echoes/0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/params-extractor/echoes/0").getStatus());
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/params-extractor/echoes/1").getStatus());
    }

    @Test
    public void testPutEchoXML() throws Exception {
        MockHttpServletResponse response = this.putAsServletResponse("/rest/params-extractor/echoes/0", "<EchoParameter id=\"0\" parameter=\"abcd\" activated=\"false\"/>", "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDom("/rest/params-extractor/echoes/0", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/EchoParameter)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/EchoParameter/@activated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/EchoParameter/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"abcd", (String)"/EchoParameter/@parameter", (Document)dom);
    }

    @Test
    public void testPutEchoJSON() throws Exception {
        String jsonBody = "{\"EchoParameter\": {\n  \"id\": 1,\n  \"parameter\": \"test123\",\n  \"activated\": true\n}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/params-extractor/echoes/1", jsonBody, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDom("/rest/params-extractor/echoes/1", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/EchoParameter)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/EchoParameter/@activated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/EchoParameter/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"test123", (String)"/EchoParameter/@parameter", (Document)dom);
    }

    @Test
    public void testPostEchoXML() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("/rest/params-extractor/echoes", "<EchoParameter parameter=\"zxw\" activated=\"true\"/>", "application/xml");
        this.checkCreateWithPost(response);
    }

    @Test
    public void testPostEchoJSON() throws Exception {
        String jsonBody = "{\"EchoParameter\": {\n  \"parameter\": \"zxw\",\n  \"activated\": true\n}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/params-extractor/echoes", jsonBody, "application/json");
        this.checkCreateWithPost(response);
    }

    private void checkCreateWithPost(MockHttpServletResponse response) throws Exception {
        Assert.assertEquals((long)HttpStatus.CREATED.value(), (long)response.getStatus());
        String location = response.getHeader("Location");
        Pattern pattern = Pattern.compile("http://localhost:8080/geoserver/rest/params-extractor/echoes/(.+)");
        Matcher matcher = pattern.matcher(location);
        Assert.assertTrue((boolean)matcher.matches());
        String id = matcher.group(1);
        Document dom = this.getAsDom("/rest/params-extractor/echoes/" + id, "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/EchoParameter)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/EchoParameter/@activated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)id, (String)"/EchoParameter/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"zxw", (String)"/EchoParameter/@parameter", (Document)dom);
    }
}

