/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.wicket.markup.repeater.data.DataView;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.web.ParamsExtractorConfigPage;
import org.geoserver.params.extractor.web.ParamsExtractorRulePage;
import org.geoserver.util.IOUtils;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParamsExtractorConfigPageTest
extends GeoServerWicketTestSupport {
    @Before
    public void prepareConfiguration() throws IOException {
        InputStream is;
        GeoServerDataDirectory dd = this.getDataDirectory();
        try (OutputStream os = dd.get(new String[]{EchoParametersDao.getEchoParametersPath()}).out();){
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/data/echoParameters3.xml");
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        os = dd.get(new String[]{RulesDao.getRulesPath()}).out();
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/data/rules4.xml");
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    @Test
    public void testPage() {
        this.login();
        tester.startPage(ParamsExtractorConfigPage.class);
        tester.assertRenderedPage(ParamsExtractorConfigPage.class);
        DataView table = (DataView)tester.getComponentFromLastRenderedPage("rulesPanel:listContainer:items");
        Assert.assertEquals((long)2L, (long)table.getItemCount());
        tester.assertModelValue("rulesPanel:listContainer:items:1:itemProperties:1:component", (Object)"^.*?(/([^/]+?))/[^/]+$");
        tester.assertModelValue("rulesPanel:listContainer:items:2:itemProperties:3:component", (Object)"CQL_FILTER");
    }

    @Test
    public void testEditComplexRule() {
        this.login();
        tester.startPage(ParamsExtractorConfigPage.class);
        tester.assertRenderedPage(ParamsExtractorConfigPage.class);
        tester.clickLink("rulesPanel:listContainer:items:1:itemProperties:10:component:edit:link");
        tester.assertRenderedPage(ParamsExtractorRulePage.class);
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.ComplexRulePanel.class);
        tester.assertModelValue("form:tabs:panel:match", (Object)"^.*?(/([^/]+?))/[^/]+$");
    }

    @Test
    public void testEditEchoRule() {
        this.login();
        tester.startPage(ParamsExtractorConfigPage.class);
        tester.assertRenderedPage(ParamsExtractorConfigPage.class);
        tester.clickLink("rulesPanel:listContainer:items:2:itemProperties:10:component:edit:link");
        tester.assertRenderedPage(ParamsExtractorRulePage.class);
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.EchoParameterPanel.class);
        tester.assertModelValue("form:tabs:panel:parameter", (Object)"CQL_FILTER");
    }
}

