/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.Utils;

public class EchoParameterBuilder {
    private String id;
    private String parameter;
    private Boolean activated;

    public EchoParameterBuilder copy(EchoParameter other) {
        this.id = other.getId();
        this.parameter = other.getParameter();
        this.activated = other.getActivated();
        return this;
    }

    public EchoParameterBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public EchoParameterBuilder withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    public EchoParameterBuilder withActivated(Boolean activated) {
        this.activated = activated;
        return this;
    }

    public EchoParameter build() {
        Utils.checkCondition(this.id != null, "Id cannot be NULL.", new Object[0]);
        Utils.checkCondition(this.parameter != null, "Parameter cannot be NULL.", new Object[0]);
        return new EchoParameter(this.id, this.parameter, Utils.withDefault(this.activated, true));
    }
}

