/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.params.extractor.UrlTransform;
import org.geoserver.params.extractor.Utils;
import org.geotools.util.logging.Logging;

public final class Rule {
    private static final Logger LOGGER = Logging.getLogger(Rule.class);
    private final String id;
    private final Boolean activated;
    private final Integer position;
    private final String match;
    private final String activation;
    private final String parameter;
    private final String transform;
    private final Integer remove;
    private final String combine;
    private final Pattern matchPattern;
    private final Pattern activationPattern;
    private final Boolean repeat;

    public Rule(String id, Boolean activated, Integer position, String match, String activation, String parameter, String transform, Integer remove, String combine, Boolean repeat, Pattern matchPattern, Pattern activationPattern) {
        this.id = id;
        this.activated = activated;
        this.position = position;
        this.match = match;
        this.activation = activation;
        this.parameter = parameter;
        this.transform = transform;
        this.remove = remove;
        this.combine = combine;
        this.repeat = repeat;
        this.matchPattern = matchPattern;
        this.activationPattern = activationPattern;
    }

    public UrlTransform apply(UrlTransform urlTransform) {
        if (!this.activated.booleanValue()) {
            Utils.debug(LOGGER, "Rule %s is deactivated.", this.id, urlTransform);
            return urlTransform;
        }
        Utils.debug(LOGGER, "Start applying rule %s to URL '%s'.", this.id, urlTransform);
        if (this.activationPattern != null && !this.activationPattern.matcher(urlTransform.getOriginalRequestUri()).matches()) {
            Utils.debug(LOGGER, "Rule %s doesn't apply to URL '%s'.", this.id, urlTransform);
            return urlTransform;
        }
        Matcher matcher = this.matchPattern.matcher(urlTransform.getOriginalRequestUri());
        if (!matcher.matches()) {
            Utils.debug(LOGGER, "Rule %s doesn't match URL '%s'.", this.id, urlTransform);
            return urlTransform;
        }
        urlTransform.removeMatch(matcher.group(this.remove != null ? this.remove : 1));
        urlTransform.addParameter(this.parameter, ResponseUtils.urlDecode((String)matcher.replaceAll(this.transform)), this.combine, this.repeat);
        return urlTransform;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getActivated() {
        return this.activated;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getMatch() {
        return this.match;
    }

    public String getActivation() {
        return this.activation;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getTransform() {
        return this.transform;
    }

    public Integer getRemove() {
        return this.remove;
    }

    public String getCombine() {
        return this.combine;
    }

    public Boolean getRepeat() {
        return this.repeat;
    }
}

