/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import com.thoughtworks.xstream.converters.Converter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleConverter;
import org.geoserver.params.extractor.Utils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public final class RulesDao {
    private static final Logger LOGGER = Logging.getLogger(RulesDao.class);
    private static final SecureXStream xStream = new SecureXStream();

    public static String getRulesPath() {
        return "params-extractor/extraction-rules.xml";
    }

    public static String getTempRulesPath() {
        return String.format("params-extractor/%s-extraction-rules.xml", UUID.randomUUID());
    }

    public static List<Rule> getRules() {
        Resource rules = RulesDao.getDataDirectory().get(new String[]{RulesDao.getRulesPath()});
        return RulesDao.getRules(rules);
    }

    private static GeoServerDataDirectory getDataDirectory() {
        return (GeoServerDataDirectory)GeoServerExtensions.bean((String)"dataDirectory");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Rule> getRules(Resource resource) {
        if (resource.getType() != Resource.Type.RESOURCE) {
            Utils.info(LOGGER, "Rule file does not exist.", new Object[0]);
            return new ArrayList<Rule>();
        }
        try (InputStream inputStream = resource.in();){
            if (inputStream.available() == 0) {
                Utils.info(LOGGER, "Parameters extractor rules file seems to be empty.", new Object[0]);
                return new ArrayList<Rule>();
            }
            RuleList list = (RuleList)xStream.fromXML(inputStream);
            List<Object> rules = list.rules == null ? new ArrayList() : list.rules;
            Utils.info(LOGGER, "Parameters extractor loaded %d rules.", rules.size());
            List<Object> list2 = rules;
            return list2;
        }
        catch (Exception exception) {
            throw Utils.exception(exception, "Error parsing rules files.", new Object[0]);
        }
    }

    public static void saveOrUpdateRule(Rule rule) {
        Resource rules = RulesDao.getDataDirectory().get(new String[]{RulesDao.getRulesPath()});
        Resource tmpRules = RulesDao.getDataDirectory().get(new String[]{RulesDao.getTempRulesPath()});
        RulesDao.saveOrUpdateRule(rule, rules, tmpRules);
        rules.delete();
        tmpRules.renameTo(rules);
    }

    public static void saveOrUpdateRule(Rule rule, Resource in, Resource out) {
        List<Rule> rules = RulesDao.getRules(in);
        boolean exists = false;
        for (int i = 0; i < rules.size() && !exists; ++i) {
            if (!rules.get(i).getId().equals(rule.getId())) continue;
            rules.set(i, rule);
            exists = true;
        }
        if (!exists) {
            rules.add(rule);
        }
        RulesDao.writeRules(rules, out);
        Utils.info(LOGGER, "Parameters extractor rules updated.", new Object[0]);
    }

    public static void deleteRules(String ... rulesIds) {
        Resource rules = RulesDao.getDataDirectory().get(new String[]{RulesDao.getRulesPath()});
        Resource tmpRules = RulesDao.getDataDirectory().get(new String[]{RulesDao.getTempRulesPath()});
        RulesDao.deleteRules(rules, tmpRules, rulesIds);
        rules.delete();
        tmpRules.renameTo(rules);
    }

    public static void deleteRules(Resource input, Resource output, String ... ruleIds) {
        List<Rule> rules = RulesDao.getRules(input).stream().filter(rule -> !RulesDao.matchesAnyRuleId(rule, ruleIds)).collect(Collectors.toList());
        RulesDao.writeRules(rules, output);
        Utils.info(LOGGER, "Deleted one or more parameters extractor rules.", new Object[0]);
    }

    private static boolean matchesAnyRuleId(Rule rule, String[] ruleIds) {
        return Arrays.stream(ruleIds).anyMatch(ruleId -> ruleId.equals(rule.getId()));
    }

    private static void writeRules(List<Rule> rules, Resource resource) {
        try (OutputStream outputStream = resource.out();){
            xStream.toXML((Object)new RuleList(rules), outputStream);
        }
        catch (Exception exception) {
            throw Utils.exception(exception, "Something bad happen when writing rules.", new Object[0]);
        }
    }

    static {
        xStream.registerConverter((Converter)new RuleConverter());
        xStream.alias("Rule", Rule.class);
        xStream.alias("Rules", RuleList.class);
        xStream.addImplicitCollection(RuleList.class, "rules");
        xStream.allowTypes(new Class[]{Rule.class, RuleList.class});
    }

    static final class RuleList {
        List<Rule> rules;

        public RuleList(List<Rule> rules) {
            this.rules = rules;
        }
    }
}

