/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.ows.util.ResponseUtils;

public class UrlTransform {
    private final Map<String, String> normalizedNames = new HashMap<String, String>();
    private final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final String requestUri;
    private final List<String> replacements = new ArrayList<String>();

    public UrlTransform(String requestUri, Map<String, String[]> parameters) {
        this.requestUri = requestUri;
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            this.normalizedNames.put(entry.getKey().toLowerCase(), entry.getKey());
            this.parameters.put(entry.getKey(), Arrays.copyOf(entry.getValue(), entry.getValue().length));
        }
    }

    public String getOriginalRequestUri() {
        return this.requestUri;
    }

    public String getRequestUri() {
        String updatedRequestUri = this.requestUri;
        for (String replacement : this.replacements) {
            updatedRequestUri = updatedRequestUri.replace(replacement, "");
        }
        return updatedRequestUri;
    }

    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, String[]> parameter : this.parameters.entrySet()) {
            queryStringBuilder.append(parameter.getKey()).append("=").append(ResponseUtils.urlEncode((String)parameter.getValue()[0], (char[])new char[0])).append("&");
        }
        if (queryStringBuilder.length() == 0) {
            return "";
        }
        queryStringBuilder.deleteCharAt(queryStringBuilder.length() - 1);
        return queryStringBuilder.toString();
    }

    public void addParameter(String name, String value, String combine, Boolean repeat) {
        String rawName = this.getRawName(name);
        String layersRawName = this.getRawName("layers");
        String[] existingValues = this.parameters.get(rawName);
        if ((existingValues != null || repeat.booleanValue()) && combine != null) {
            int num = 1;
            if (repeat.booleanValue() && this.parameters.containsKey(layersRawName) && this.parameters.get(layersRawName) != null) {
                num = this.parameters.get(layersRawName)[0].split(",").length;
            }
            String existingValue = existingValues == null ? null : existingValues[0];
            for (int count = 0; count < num; ++count) {
                String combinedValue = existingValue == null ? "$2" : combine.replace("$1", existingValue);
                existingValue = combinedValue = combinedValue.replace("$2", value);
            }
            this.parameters.put(rawName, new String[]{existingValue});
        } else {
            this.parameters.put(rawName, new String[]{value});
        }
    }

    private String getRawName(String name) {
        String rawName = this.normalizedNames.get(name.toLowerCase());
        if (rawName != null) {
            return rawName;
        }
        this.normalizedNames.put(name.toLowerCase(), name);
        return name;
    }

    public void removeMatch(String matchedText) {
        this.replacements.add(matchedText);
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public boolean haveChanged() {
        return !this.replacements.isEmpty();
    }

    public String toString() {
        String updatedQueryString = this.getQueryString();
        if (updatedQueryString.isEmpty()) {
            return this.getRequestUri();
        }
        return this.getRequestUri() + "?" + this.getQueryString();
    }
}

