/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.web;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.Utils;
import org.geoserver.params.extractor.web.RuleModel;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class RulesModel
extends GeoServerDataProvider<RuleModel> {
    public static final GeoServerDataProvider.Property<RuleModel> EDIT_BUTTON = new GeoServerDataProvider.PropertyPlaceholder("Edit");
    public static final GeoServerDataProvider.Property<RuleModel> ACTIVATE_BUTTON = new GeoServerDataProvider.PropertyPlaceholder("Active");
    private static final List<GeoServerDataProvider.Property<RuleModel>> PROPERTIES = Arrays.asList(new GeoServerDataProvider.BeanProperty("Position", "position"), new GeoServerDataProvider.BeanProperty("Match", "match"), new GeoServerDataProvider.BeanProperty("Activation", "activation"), new GeoServerDataProvider.BeanProperty("Parameter", "parameter"), new GeoServerDataProvider.BeanProperty("Transform", "transform"), new GeoServerDataProvider.BeanProperty("Remove", "remove"), new GeoServerDataProvider.BeanProperty("Combine", "combine"), new GeoServerDataProvider.BeanProperty("Repeat", "repeat"), new GeoServerDataProvider.BeanProperty("Echo", "echo"), ACTIVATE_BUTTON, EDIT_BUTTON);

    protected List<GeoServerDataProvider.Property<RuleModel>> getProperties() {
        return PROPERTIES;
    }

    protected List<RuleModel> getItems() {
        return RulesModel.getRulesModels();
    }

    public static List<RuleModel> getRulesModels() {
        List<RuleModel> ruleModels = RulesDao.getRules().stream().map(RuleModel::new).collect(Collectors.toList());
        EchoParametersDao.getEchoParameters().forEach(forwardParameter -> RulesModel.mergedForwardParameter(ruleModels, forwardParameter));
        return ruleModels;
    }

    public static void saveOrUpdate(RuleModel ruleModel) {
        if (!ruleModel.isEchoOnly()) {
            RulesDao.saveOrUpdateRule(ruleModel.toRule());
            if (!ruleModel.getEcho()) {
                EchoParametersDao.deleteEchoParameters(ruleModel.getId());
            }
        }
        if (ruleModel.getEcho() || ruleModel.isEchoOnly()) {
            EchoParametersDao.saveOrUpdateEchoParameter(ruleModel.toEchoParameter());
        }
    }

    public static void delete(String ... rulesIds) {
        RulesDao.deleteRules(rulesIds);
        EchoParametersDao.deleteEchoParameters(rulesIds);
    }

    private static void mergedForwardParameter(List<RuleModel> ruleModels, EchoParameter echoParameter) {
        for (RuleModel ruleModel : ruleModels) {
            if (!ruleModel.getId().equals(echoParameter.getId())) continue;
            Utils.checkCondition(echoParameter.getParameter().equals(ruleModel.getParameter()), "Rule and echo parameter with id '%s' should have the same parameter.", ruleModel.getId());
            Utils.checkCondition(echoParameter.getActivated() == ruleModel.getActivated(), "Rule and echo parameter with id '%s' should both be deactivated or activated.", ruleModel.getId());
            ruleModel.setEcho(true);
            return;
        }
        ruleModels.add(new RuleModel(echoParameter));
    }
}

