/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.rest;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import net.sf.json.JSON;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public abstract class ParamsExtractorRestTestSupport
extends GeoServerSystemTestSupport {
    protected static XpathEngine xp;

    protected void setUpTestData(SystemTestData testData) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("atom", "http://www.w3.org/2005/Atom");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xp = XMLUnit.newXpathEngine();
    }

    public Document getAsDom(String path, String contentType, int status) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((long)status, (long)response.getStatus());
        Assert.assertEquals((Object)contentType, (Object)response.getContentType());
        return this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
    }

    public JSON getAsJSON(String path, String contentType, int status) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((long)status, (long)response.getStatus());
        Assert.assertEquals((Object)contentType, (Object)response.getContentType());
        return this.json(response);
    }
}

