/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Optional;
import java.util.UUID;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParameterBuilder;

public class EchoParameterConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        EchoParameter param = (EchoParameter)source;
        writer.addAttribute("id", param.getId());
        writer.addAttribute("parameter", param.getParameter());
        writer.addAttribute("activated", String.valueOf(param.getActivated()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return new EchoParameterBuilder().withId(Optional.ofNullable(reader.getAttribute("id")).orElse(UUID.randomUUID().toString())).withActivated(Boolean.valueOf(reader.getAttribute("activated"))).withParameter(reader.getAttribute("parameter")).build();
    }

    public boolean canConvert(Class type) {
        return EchoParameter.class.equals((Object)type);
    }
}

