/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.params.extractor.RequestWrapper;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.UrlTransform;
import org.geoserver.params.extractor.Utils;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;

public final class Filter
implements GeoServerFilter,
ExtensionPriority {
    private static final Logger LOGGER = Logging.getLogger(Filter.class);
    static boolean USE_AS_SERVLET_FILTER = false;
    private boolean servletInstance = false;
    private List<Rule> rules = new ArrayList<Rule>();

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public Filter() {
        USE_AS_SERVLET_FILTER = true;
        this.servletInstance = true;
        this.logFilterInitiation();
    }

    public Filter(GeoServerDataDirectory dataDirectory) {
        this.servletInstance = false;
        this.initRules(dataDirectory);
        this.logFilterInitiation();
    }

    private void logFilterInitiation() {
        Utils.info(LOGGER, "Parameters extractor filter initiated [USE_AS_SERVLET_FILTER=%s, SERVLET_INSTANCE=%s].", USE_AS_SERVLET_FILTER, this.servletInstance);
    }

    private void initRules(GeoServerDataDirectory dataDirectory) {
        if (dataDirectory != null) {
            Utils.info(LOGGER, "Initiating parameters extractor rules.", new Object[0]);
            Resource resource = dataDirectory.get(new String[]{RulesDao.getRulesPath()});
            this.rules = RulesDao.getRules(resource);
            resource.addListener(notify -> {
                this.rules = RulesDao.getRules(resource);
            });
        } else {
            Utils.info(LOGGER, "No data directory provided, no parameters extractor rules were loaded.", new Object[0]);
        }
    }

    public int getPriority() {
        return 0;
    }

    public void init(FilterConfig filterConfig) {
        GeoServerDataDirectory dataDirectory = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class);
        Utils.info(LOGGER, "Initiating parameters extractor as a standard web container filter.", new Object[0]);
        this.initRules(dataDirectory);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isEnabled()) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (!httpServletRequest.getRequestURI().contains("web/wicket") && !httpServletRequest.getRequestURI().contains("geoserver/web")) {
                UrlTransform urlTransform = new UrlTransform(httpServletRequest.getRequestURI(), httpServletRequest.getParameterMap());
                String originalRequest = urlTransform.toString();
                this.rules.forEach(rule -> rule.apply(urlTransform));
                Utils.debug(LOGGER, "About to evaluate request '%s' with parameters extractor (%d) rules.", originalRequest, this.rules.size());
                if (urlTransform.haveChanged()) {
                    Utils.info(LOGGER, "Request '%s' transformed to '%s'.", originalRequest, urlTransform.toString());
                    request = new RequestWrapper(urlTransform, httpServletRequest);
                } else {
                    Utils.debug(LOGGER, "No parameters extractor rules matched with the request '%s'.", originalRequest);
                }
            } else {
                Utils.debug(LOGGER, "Request '%s' ignored by parameters extractor.", httpServletRequest.getRequestURI());
            }
        } else {
            Utils.debug(LOGGER, "Parameters extractor is disabled.", new Object[0]);
        }
        chain.doFilter(request, response);
    }

    boolean isEnabled() {
        return !USE_AS_SERVLET_FILTER || this.servletInstance;
    }

    public void destroy() {
    }
}

