/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.params.extractor.EchoParameter;
import org.geoserver.params.extractor.EchoParametersDao;
import org.geoserver.params.extractor.RequestWrapper;
import org.geoserver.params.extractor.Utils;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public class UrlMangler
implements URLMangler {
    private static final Logger LOGGER = Logging.getLogger(UrlMangler.class);
    private List<EchoParameter> echoParameters;

    public UrlMangler(GeoServerDataDirectory dataDirectory) {
        Resource resource = dataDirectory.get(new String[]{EchoParametersDao.getEchoParametersPath()});
        this.echoParameters = EchoParametersDao.getEchoParameters(resource);
        resource.addListener(notify -> {
            this.echoParameters = EchoParametersDao.getEchoParameters(resource);
        });
    }

    private HttpServletRequest getHttpRequest(Request request) {
        HttpServletRequest httpRequest = request.getHttpRequest();
        while (httpRequest instanceof HttpServletRequestWrapper && !(httpRequest instanceof RequestWrapper)) {
            ServletRequest servlet = ((HttpServletRequestWrapper)httpRequest).getRequest();
            if (servlet instanceof HttpServletRequest) {
                httpRequest = (HttpServletRequest)servlet;
                continue;
            }
            throw new RuntimeException("Only HttpRequest is supported");
        }
        return httpRequest;
    }

    public void mangleURL(StringBuilder baseURL, StringBuilder path, Map<String, String> kvp, URLMangler.URLType type) {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null || !"GetCapabilities".equalsIgnoreCase(request.getRequest())) {
            Utils.debug(LOGGER, "Not a capabilities request, ignored by the parameters extractor URL mangler.", new Object[0]);
            return;
        }
        this.forwardOriginalUri(request, path);
        Map requestRawKvp = request.getRawKvp();
        HttpServletRequest httpRequest = this.getHttpRequest(request);
        if (httpRequest instanceof RequestWrapper) {
            RequestWrapper requestWrapper = (RequestWrapper)httpRequest;
            Map<String, String[]> parameters = requestWrapper.getOriginalParameters();
            requestRawKvp = new KvpMap((Map)KvpUtils.normalize(parameters));
        }
        this.forwardParameters(requestRawKvp, kvp);
        Utils.debug(LOGGER, "Parameters extractor URL mangler applied.", new Object[0]);
    }

    private void forwardOriginalUri(Request request, StringBuilder path) {
        HttpServletRequest httpRequest = this.getHttpRequest(request);
        String requestUri = httpRequest.getRequestURI();
        if (httpRequest instanceof RequestWrapper) {
            requestUri = ((RequestWrapper)httpRequest).getOriginalRequestURI();
        }
        int i = httpRequest.getContextPath().length() + 1;
        String pathInfo = requestUri.substring(i);
        path.delete(0, path.length());
        path.append(pathInfo);
    }

    private void forwardParameters(Map<String, Object> requestRawKvp, Map<String, String> kvp) {
        for (EchoParameter echoParameter : this.echoParameters) {
            Map.Entry<String, Object> rawParameter;
            if (!echoParameter.getActivated() || (rawParameter = Utils.caseInsensitiveSearch(echoParameter.getParameter(), requestRawKvp)) == null || Utils.caseInsensitiveSearch(echoParameter.getParameter(), kvp) != null || !(rawParameter.getValue() instanceof String)) continue;
            kvp.put(rawParameter.getKey(), (String)rawParameter.getValue());
        }
    }
}

