/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.params.extractor.web.ParamsExtractorConfigPage;
import org.geoserver.params.extractor.web.RuleModel;
import org.geoserver.params.extractor.web.RulesModel;
import org.geoserver.web.GeoServerSecuredPage;

public class ParamsExtractorRulePage
extends GeoServerSecuredPage {
    public ParamsExtractorRulePage(Optional<RuleModel> optionalRuleModel) {
        final CompoundPropertyModel simpleRuleModel = new CompoundPropertyModel((Object)optionalRuleModel.orElse(new RuleModel()));
        final CompoundPropertyModel complexRuleModel = new CompoundPropertyModel((Object)optionalRuleModel.orElse(new RuleModel()));
        final CompoundPropertyModel echoParameterModel = new CompoundPropertyModel((Object)optionalRuleModel.orElse(new RuleModel(true)));
        Form form = new Form("form");
        this.add(new Component[]{form});
        final ArrayList<WrappedTab> tabs = new ArrayList<WrappedTab>();
        if (!optionalRuleModel.isPresent() || optionalRuleModel.get().isEchoOnly()) {
            tabs.add(new WrappedTab("Echo Parameter", (IModel)echoParameterModel){

                public Panel getPanel(String panelId) {
                    return new EchoParameterPanel(panelId, (IModel<RuleModel>)echoParameterModel);
                }
            });
        }
        if (!optionalRuleModel.isPresent() || optionalRuleModel.get().getPosition() != null) {
            tabs.add(new WrappedTab("Basic Rule", (IModel)simpleRuleModel){

                public Panel getPanel(String panelId) {
                    return new SimpleRulePanel(panelId, (IModel<RuleModel>)simpleRuleModel);
                }
            });
        }
        if (!optionalRuleModel.isPresent() || optionalRuleModel.get().getMatch() != null) {
            tabs.add(new WrappedTab("Advanced Rule", (IModel)complexRuleModel){

                public Panel getPanel(String panelId) {
                    return new ComplexRulePanel(panelId, (IModel<RuleModel>)complexRuleModel);
                }
            });
        }
        final AjaxTabbedPanel tabbedPanel = new AjaxTabbedPanel("tabs", tabs);
        form.add(new Component[]{tabbedPanel});
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                try {
                    WrappedTab selectedTab = (WrappedTab)((Object)tabs.get(tabbedPanel.getSelectedTab()));
                    RuleModel ruleModel = (RuleModel)selectedTab.getModel().getObject();
                    RulesModel.saveOrUpdate(ruleModel);
                    ParamsExtractorRulePage.this.doReturn(ParamsExtractorConfigPage.class);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
            }
        }});
        form.add(new Component[]{new BookmarkablePageLink("cancel", ParamsExtractorConfigPage.class)});
    }

    public class EchoParameterPanel
    extends Panel {
        public EchoParameterPanel(String panelId, IModel<RuleModel> model) {
            super(panelId, model);
            this.add(new Component[]{new TextField("parameter").setRequired(true)});
        }
    }

    public class ComplexRulePanel
    extends Panel {
        public ComplexRulePanel(String panelId, IModel<RuleModel> model) {
            super(panelId, model);
            this.add(new Component[]{new TextField("match").setRequired(true)});
            this.add(new Component[]{new TextField("activation")});
            this.add(new Component[]{new TextField("parameter").setRequired(true)});
            this.add(new Component[]{new TextField("transform").setRequired(true)});
            this.add(new Component[]{new NumberTextField("remove").setMinimum((Number)1)});
            this.add(new Component[]{new TextField("combine")});
            this.add(new Component[]{new CheckBox("repeat")});
            this.add(new Component[]{new CheckBox("echo")});
        }
    }

    public class SimpleRulePanel
    extends Panel {
        public SimpleRulePanel(String panelId, IModel<RuleModel> model) {
            super(panelId, model);
            this.add(new Component[]{new NumberTextField("position").setMinimum((Number)1).setRequired(true)});
            this.add(new Component[]{new TextField("parameter").setRequired(true)});
            this.add(new Component[]{new TextField("transform").setRequired(true)});
            this.add(new Component[]{new CheckBox("echo")});
        }
    }

    public abstract class WrappedTab
    extends AbstractTab {
        private final IModel<RuleModel> model;

        public WrappedTab(String title, IModel<RuleModel> model) {
            super((IModel)new Model((Serializable)((Object)title)));
            this.model = model;
        }

        public IModel<RuleModel> getModel() {
            return this.model;
        }
    }
}

