/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.params.extractor.Filter;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleBuilder;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.TestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockFilterConfig;

public class FilterTest
extends TestSupport {
    FilterConfig filterConfig;

    @Before
    public void setUp() {
        this.filterConfig = new MockFilterConfig();
        Rule ruleA = new RuleBuilder().withId("0").withActivated(Boolean.valueOf(true)).withPosition(Integer.valueOf(3)).withParameter("cql_filter").withTransform("CFCC='$2'").build();
        RulesDao.saveOrUpdateRule((Rule)ruleA);
        Filter.USE_AS_SERVLET_FILTER = false;
    }

    @Test
    public void testAsServletFilter() throws ServletException {
        Filter filter = new Filter();
        filter.init(this.filterConfig);
        Assert.assertTrue((boolean)filter.isEnabled());
    }

    @Test
    public void testAsSpringFilter() throws Exception {
        GeoServerDataDirectory dataDirectory = (GeoServerDataDirectory)APPLICATION_CONTEXT.getBean(GeoServerDataDirectory.class);
        Filter filter = new Filter(dataDirectory);
        Assert.assertTrue((boolean)filter.isEnabled());
    }

    @Test
    public void testServletFilterHasPriorityOverSpring() throws ServletException {
        Filter servletFilter = new Filter();
        servletFilter.init(this.filterConfig);
        GeoServerDataDirectory dataDirectory = (GeoServerDataDirectory)APPLICATION_CONTEXT.getBean(GeoServerDataDirectory.class);
        Filter springFilter = new Filter(dataDirectory);
        Assert.assertTrue((boolean)servletFilter.isEnabled());
        Assert.assertFalse((boolean)springFilter.isEnabled());
    }
}

