/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.Optional;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.RuleBuilder;
import org.geoserver.params.extractor.UrlTransform;
import org.geoserver.params.extractor.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class RuleTest {
    @Test
    public void testPositionRule() throws Exception {
        Rule ruleA = new RuleBuilder().withId("0").withPosition(Integer.valueOf(3)).withParameter("CQL_FILTER").withTransform("CFCC='$2'").build();
        Rule ruleB = new RuleBuilder().withId("1").withPosition(Integer.valueOf(4)).withParameter("CQL_FILTER").withTransform("CFCC='$2'").withCombine("$1 AND $2").build();
        UrlTransform urlTransform = new UrlTransform("/geoserver/tiger/wms/H11/D68", Utils.parseParameters(Optional.of("REQUEST=GetMap")));
        ruleA.apply(urlTransform);
        this.checkParametersSize(urlTransform, 2);
        this.checkParameterWithValue(urlTransform, "REQUEST", "GetMap");
        this.checkParameterWithValue(urlTransform, "CQL_FILTER", "CFCC='H11'");
        MatcherAssert.assertThat((Object)urlTransform.getRequestUri(), (Matcher)CoreMatchers.is((Object)"/geoserver/tiger/wms/D68"));
        ruleB.apply(urlTransform);
        this.checkParametersSize(urlTransform, 2);
        this.checkParameterWithValue(urlTransform, "REQUEST", "GetMap");
        this.checkParameterWithValue(urlTransform, "CQL_FILTER", "CFCC='H11' AND CFCC='D68'");
        MatcherAssert.assertThat((Object)urlTransform.getRequestUri(), (Matcher)CoreMatchers.is((Object)"/geoserver/tiger/wms"));
    }

    @Test
    public void testMatchRule() throws Exception {
        Rule rule = new RuleBuilder().withId("0").withMatch("^.*?(/([^/]+)/([^/]+))$").withParameter("CQL_FILTER").withTransform("CFCC='$2' AND CFCC='$3'").build();
        UrlTransform urlTransform = new UrlTransform("/geoserver/tiger/wms/H11/D68", Utils.parseParameters(Optional.of("REQUEST=GetMap")));
        rule.apply(urlTransform);
        this.checkParametersSize(urlTransform, 2);
        this.checkParameterWithValue(urlTransform, "REQUEST", "GetMap");
        this.checkParameterWithValue(urlTransform, "CQL_FILTER", "CFCC='H11' AND CFCC='D68'");
        MatcherAssert.assertThat((Object)urlTransform.getRequestUri(), (Matcher)CoreMatchers.is((Object)"/geoserver/tiger/wms"));
    }

    @Test
    public void testCombineWithRepeat() throws Exception {
        Rule rule = new RuleBuilder().withId("0").withMatch("^.*?(/([^/]+))$").withParameter("CQL_FILTER").withTransform("CFCC='$2'").withCombine("$1;$2").withRepeat(Boolean.valueOf(true)).build();
        UrlTransform urlTransform = new UrlTransform("/geoserver/wms/H11", Utils.parseParameters(Optional.of("REQUEST=GetMap&LAYERS=tiger,tiger")));
        rule.apply(urlTransform);
        this.checkParametersSize(urlTransform, 3);
        this.checkParameterWithValue(urlTransform, "REQUEST", "GetMap");
        this.checkParameterWithValue(urlTransform, "CQL_FILTER", "CFCC='H11';CFCC='H11'");
        MatcherAssert.assertThat((Object)urlTransform.getRequestUri(), (Matcher)CoreMatchers.is((Object)"/geoserver/wms"));
    }

    @Test
    public void testMatchRuleWithExistingParameter() throws Exception {
        Rule rule = new RuleBuilder().withId("0").withMatch("^.*?(/([^/]+)/([^/]+))$").withParameter("CQL_FILTER").withTransform("CFCC='$2' AND CFCC='$3'").withCombine("$1 OR ($2)").build();
        UrlTransform urlTransform = new UrlTransform("/geoserver/tiger/wms/H11/D68", Utils.parseParameters(Optional.of("REQUEST=GetMap&CQL_FILTER=CFCC%3D%27Y56%27")));
        rule.apply(urlTransform);
        this.checkParametersSize(urlTransform, 2);
        this.checkParameterWithValue(urlTransform, "REQUEST", "GetMap");
        this.checkParameterWithValue(urlTransform, "CQL_FILTER", "CFCC='Y56' OR (CFCC='H11' AND CFCC='D68')");
        MatcherAssert.assertThat((Object)urlTransform.getRequestUri(), (Matcher)CoreMatchers.is((Object)"/geoserver/tiger/wms"));
    }

    @Test
    public void testMatchRuleWithExistingParameterDifferentCases() throws Exception {
        Rule rule = new RuleBuilder().withId("0").withMatch("^.*?(/([^/]+)/([^/]+))$").withParameter("CQL_filter").withTransform("CFCC='$2' AND CFCC='$3'").withCombine("$1 OR ($2)").build();
        UrlTransform urlTransform = new UrlTransform("/geoserver/tiger/wms/H11/D68", Utils.parseParameters(Optional.of("REQUEST=GetMap&cql_filter=CFCC%3D%27Y56%27")));
        rule.apply(urlTransform);
        this.checkParametersSize(urlTransform, 2);
        this.checkParameterWithValue(urlTransform, "REQUEST", "GetMap");
        this.checkParameterWithValue(urlTransform, "cql_filter", "CFCC='Y56' OR (CFCC='H11' AND CFCC='D68')");
        MatcherAssert.assertThat((Object)urlTransform.getRequestUri(), (Matcher)CoreMatchers.is((Object)"/geoserver/tiger/wms"));
    }

    private void checkParametersSize(UrlTransform urlTransform, int expectedSize) {
        MatcherAssert.assertThat((Object)urlTransform.getParameters().size(), (Matcher)CoreMatchers.is((Object)expectedSize));
    }

    private void checkParameterWithValue(UrlTransform urlTransform, String name, String value) {
        String[] foundValue = (String[])urlTransform.getParameters().get(name);
        MatcherAssert.assertThat((Object)foundValue, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)foundValue[0], (Matcher)CoreMatchers.is((Object)value));
    }
}

