/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.params.extractor.RequestWrapper;
import org.geoserver.params.extractor.TestSupport;
import org.geoserver.params.extractor.UrlMangler;
import org.geoserver.params.extractor.UrlTransform;
import org.geoserver.platform.GeoServerExtensions;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public final class UrlManglerTest
extends TestSupport {
    protected static GeoServerDataDirectory getDataDirectory() {
        return (GeoServerDataDirectory)GeoServerExtensions.bean((String)"dataDirectory");
    }

    @Override
    public void voidClean() throws IOException {
        super.voidClean();
        Dispatcher.REQUEST.remove();
    }

    @Test
    public void testSimpleWrappedRequest() {
        HashMap params = new HashMap();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("GET", "http://127.0.0.1/geoserver/it.geosolutions/param/wms");
        httpRequest.setContextPath("/geoserver");
        UrlTransform transform = new UrlTransform("/geoserver/workspace/param/wms", params);
        transform.removeMatch("/param");
        RequestWrapper wrapper = new RequestWrapper(transform, (HttpServletRequest)httpRequest);
        Request request = new Request();
        request.setHttpRequest((HttpServletRequest)wrapper);
        request.setRequest("GetCapabilities");
        Dispatcher.REQUEST.set(request);
        UrlMangler mangler = new UrlMangler(UrlManglerTest.getDataDirectory());
        StringBuilder path = new StringBuilder("/geoserver/workspace/param/wms");
        HashMap kvp = new HashMap();
        mangler.mangleURL(new StringBuilder(), path, kvp, null);
        Assert.assertEquals((Object)"workspace/param/wms", (Object)path.toString());
    }

    @Test
    public void testDoubleWrappedRequest() {
        HashMap params = new HashMap();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("GET", "http://127.0.0.1/geoserver/it.geosolutions/param/wms");
        httpRequest.setContextPath("/geoserver");
        UrlTransform transform = new UrlTransform("/geoserver/workspace/param/wms", params);
        transform.removeMatch("/param");
        RequestWrapper wrapper = new RequestWrapper(transform, (HttpServletRequest)httpRequest);
        HttpServletRequestWrapper secondWrapper = new HttpServletRequestWrapper((HttpServletRequest)wrapper);
        Request request = new Request();
        request.setHttpRequest((HttpServletRequest)secondWrapper);
        request.setRequest("GetCapabilities");
        Dispatcher.REQUEST.set(request);
        UrlMangler mangler = new UrlMangler(UrlManglerTest.getDataDirectory());
        StringBuilder path = new StringBuilder("/geoserver/workspace/param/wms");
        HashMap kvp = new HashMap();
        mangler.mangleURL(new StringBuilder(), path, kvp, null);
        Assert.assertEquals((Object)"workspace/param/wms", (Object)path.toString());
    }

    @Test
    public void testMultiSlashContextPath() {
        HashMap params = new HashMap();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("GET", "http://127.0.0.1/my/ohmy/geoserver/it.geosolutions/param/wms");
        httpRequest.setContextPath("/my/ohmy/geoserver");
        UrlTransform transform = new UrlTransform("/my/ohmy/geoserver/workspace/param/wms", params);
        transform.removeMatch("/param");
        RequestWrapper wrapper = new RequestWrapper(transform, (HttpServletRequest)httpRequest);
        Request request = new Request();
        request.setHttpRequest((HttpServletRequest)wrapper);
        request.setRequest("GetCapabilities");
        Dispatcher.REQUEST.set(request);
        UrlMangler mangler = new UrlMangler(UrlManglerTest.getDataDirectory());
        StringBuilder path = new StringBuilder("/my/ohmy/geoserver/workspace/param/wms");
        HashMap kvp = new HashMap();
        mangler.mangleURL(new StringBuilder(), path, kvp, null);
        Assert.assertEquals((Object)"workspace/param/wms", (Object)path.toString());
    }
}

