/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.params.extractor.RulesDao;
import org.geoserver.params.extractor.rest.ParamsExtractorRestTestSupport;
import org.geoserver.util.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class RulesControllerTest
extends ParamsExtractorRestTestSupport {
    @Before
    public void prepareConfiguration() throws IOException {
        GeoServerDataDirectory dd = this.getDataDirectory();
        try (OutputStream os = dd.get(new String[]{RulesDao.getRulesPath()}).out();
             InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/data/rules5.xml");){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    @Test
    public void getGetRulesXML() throws Exception {
        Document dom = this.getAsDom("/rest/params-extractor/rules", "application/xml", 200);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/Rules", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(/Rules/Rule)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/Rules/Rule[1]/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/params-extractor/rules/0.xml", (String)"/Rules/Rule[1]/atom:link/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/Rules/Rule[2]/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/params-extractor/rules/1.xml", (String)"/Rules/Rule[2]/atom:link/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"/Rules/Rule[3]/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/params-extractor/rules/2.xml", (String)"/Rules/Rule[3]/atom:link/@href", (Document)dom);
    }

    @Test
    public void getGetRulesJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/rules.json", "application/json", 200);
        JSONObject wrapper = json.getJSONObject("Rules");
        Assert.assertNotNull((Object)wrapper);
        JSONArray array = wrapper.getJSONArray("Rule");
        Assert.assertEquals((long)3L, (long)array.size());
        Assert.assertEquals((Object)0, (Object)array.getJSONObject(0).get("id"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/params-extractor/rules/0.json", (Object)array.getJSONObject(0).get("href"));
        Assert.assertEquals((Object)1, (Object)array.getJSONObject(1).get("id"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/params-extractor/rules/1.json", (Object)array.getJSONObject(1).get("href"));
        Assert.assertEquals((Object)2, (Object)array.getJSONObject(2).get("id"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/params-extractor/rules/2.json", (Object)array.getJSONObject(2).get("href"));
    }

    @Test
    public void testGetRule0XML() throws Exception {
        Document dom = this.getAsDom("/rest/params-extractor/rules/0", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/Rule)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/Rule/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"cql_filter", (String)"/Rule/@parameter", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/Rule/@remove", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"seq='$2'", (String)"/Rule/@transform", (Document)dom);
    }

    @Test
    public void testGetRule1XML() throws Exception {
        Document dom = this.getAsDom("/rest/params-extractor/rules/1", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/Rule)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/Rule/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"^.*?(/([^/]+?))/[^/]+$", (String)"/Rule/@match", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"cql_filter", (String)"/Rule/@parameter", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"/Rule/@remove", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"seq='$2'", (String)"/Rule/@transform", (Document)dom);
    }

    @Test
    public void testGetRule2XML() throws Exception {
        Document dom = this.getAsDom("/rest/params-extractor/rules/2", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/Rule)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"/Rule/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"/Rule/@position", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"cql_filter", (String)"/Rule/@parameter", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"seq='$2'", (String)"/Rule/@transform", (Document)dom);
    }

    @Test
    public void testGetRule0JSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/rules/0.json", "application/json", 200);
        this.print((JSON)json);
        JSONObject param = json.getJSONObject("Rule");
        Assert.assertEquals((Object)0, (Object)param.get("id"));
        Assert.assertEquals((Object)true, (Object)param.get("activated"));
        Assert.assertEquals((Object)3, (Object)param.get("position"));
        Assert.assertEquals((Object)"cql_filter", (Object)param.get("parameter"));
        Assert.assertEquals((Object)1, (Object)param.get("remove"));
        Assert.assertEquals((Object)"seq='$2'", (Object)param.get("transform"));
    }

    @Test
    public void testGetRule1JSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/rules/1.json", "application/json", 200);
        JSONObject param = json.getJSONObject("Rule");
        Assert.assertEquals((Object)1, (Object)param.get("id"));
        Assert.assertEquals((Object)true, (Object)param.get("activated"));
        Assert.assertEquals((Object)"^.*?(/([^/]+?))/[^/]+$", (Object)param.get("match"));
        Assert.assertEquals((Object)"cql_filter", (Object)param.get("parameter"));
        Assert.assertEquals((Object)2, (Object)param.get("remove"));
        Assert.assertEquals((Object)"seq='$2'", (Object)param.get("transform"));
    }

    @Test
    public void testGetRule2JSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/rules/2.json", "application/json", 200);
        JSONObject param = json.getJSONObject("Rule");
        Assert.assertEquals((Object)2, (Object)param.get("id"));
        Assert.assertEquals((Object)true, (Object)param.get("activated"));
        Assert.assertEquals((Object)4, (Object)param.get("position"));
        Assert.assertEquals((Object)"cql_filter", (Object)param.get("parameter"));
        Assert.assertEquals((Object)"seq='$2'", (Object)param.get("transform"));
    }

    @Test
    public void testDeleteRule() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/params-extractor/rules/0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/params-extractor/rules/0").getStatus());
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/params-extractor/rules/1").getStatus());
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse("/rest/params-extractor/rules/2").getStatus());
    }

    @Test
    public void testPutRuleXML() throws Exception {
        String ruleXML = "<Rule id=\"0\"\n          position=\"5\"\n          parameter=\"foobar\"\n          remove=\"2\"\n          transform=\"abc='$2'\"/>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/params-extractor/rules/0", ruleXML, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDom("/rest/params-extractor/rules/0", "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/Rule)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/Rule/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"/Rule/@position", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foobar", (String)"/Rule/@parameter", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"/Rule/@remove", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"abc='$2'", (String)"/Rule/@transform", (Document)dom);
    }

    @Test
    public void testPutRuleJson() throws Exception {
        String ruleJSON = "{\"Rule\": {\n  \"id\": 0,\n  \"position\": 5,\n  \"parameter\": \"foobar\",\n  \"transform\": \"abc='$2'\",\n  \"remove\": 2\n}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/params-extractor/rules/0", ruleJSON, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSONObject json = (JSONObject)this.getAsJSON("/rest/params-extractor/rules/0.json", "application/json", 200);
        JSONObject param = json.getJSONObject("Rule");
        Assert.assertEquals((Object)0, (Object)param.get("id"));
        Assert.assertEquals((Object)true, (Object)param.get("activated"));
        Assert.assertEquals((Object)5, (Object)param.get("position"));
        Assert.assertEquals((Object)"foobar", (Object)param.get("parameter"));
        Assert.assertEquals((Object)2, (Object)param.get("remove"));
        Assert.assertEquals((Object)"abc='$2'", (Object)param.get("transform"));
    }

    @Test
    public void testPostRuleXML() throws Exception {
        String ruleXML = "<Rule           position=\"5\"\n          parameter=\"foobar\"\n          remove=\"2\"\n          transform=\"abc='$2'\"/>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/params-extractor/rules", ruleXML, "application/xml");
        this.checkCreateWithPost(response);
    }

    @Test
    public void testPostEchoJSON() throws Exception {
        String ruleJSON = "{\"Rule\": {\n  \"position\": 5,\n  \"parameter\": \"foobar\",\n  \"transform\": \"abc='$2'\",\n  \"remove\": 2\n}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/params-extractor/rules", ruleJSON, "application/json");
        this.checkCreateWithPost(response);
    }

    private void checkCreateWithPost(MockHttpServletResponse response) throws Exception {
        Assert.assertEquals((long)HttpStatus.CREATED.value(), (long)response.getStatus());
        String location = response.getHeader("Location");
        Pattern pattern = Pattern.compile("http://localhost:8080/geoserver/rest/params-extractor/rules/(.+)");
        Matcher matcher = pattern.matcher(location);
        Assert.assertTrue((boolean)matcher.matches());
        String id = matcher.group(1);
        Document dom = this.getAsDom("/rest/params-extractor/rules/" + id, "application/xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/Rule)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)id, (String)"/Rule/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"/Rule/@position", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foobar", (String)"/Rule/@parameter", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"/Rule/@remove", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"abc='$2'", (String)"/Rule/@transform", (Document)dom);
    }
}

