/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor.web;

import java.util.Optional;
import org.apache.wicket.Page;
import org.geoserver.params.extractor.web.ParamsExtractorRulePage;
import org.geoserver.params.extractor.web.RuleModel;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Before;
import org.junit.Test;

public class ParamsExtractorRulePageTest
extends GeoServerWicketTestSupport {
    private static final String PARAMETER_NAME = "foobar";
    private static final String BASIC_TRANSFORM = "CQL_FILTER=name%3D{PARAMETER}";
    private static final String COMPLEX_TRANSFORM = "CQL_FILTER=value%3D$1";

    @Before
    public void login() {
        super.login();
    }

    @Test
    public void testNew() {
        tester.startPage((Page)new ParamsExtractorRulePage(Optional.empty()));
        tester.assertRenderedPage(ParamsExtractorRulePage.class);
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.EchoParameterPanel.class);
        tester.clickLink("form:tabs:tabs-container:tabs:1:link");
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.SimpleRulePanel.class);
        tester.clickLink("form:tabs:tabs-container:tabs:2:link");
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.ComplexRulePanel.class);
    }

    @Test
    public void testForwardOnly() {
        RuleModel rule = new RuleModel(true);
        rule.setParameter(PARAMETER_NAME);
        tester.startPage((Page)new ParamsExtractorRulePage(Optional.of(rule)));
        tester.assertRenderedPage(ParamsExtractorRulePage.class);
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.EchoParameterPanel.class);
        tester.assertModelValue("form:tabs:panel:parameter", (Object)PARAMETER_NAME);
    }

    @Test
    public void testBasicRule() {
        RuleModel rule = new RuleModel(false);
        rule.setParameter(PARAMETER_NAME);
        rule.setPosition(Integer.valueOf(1));
        rule.setTransform(BASIC_TRANSFORM);
        tester.startPage((Page)new ParamsExtractorRulePage(Optional.of(rule)));
        tester.assertRenderedPage(ParamsExtractorRulePage.class);
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.SimpleRulePanel.class);
        tester.assertModelValue("form:tabs:panel:position", (Object)1);
        tester.assertModelValue("form:tabs:panel:parameter", (Object)PARAMETER_NAME);
        tester.assertModelValue("form:tabs:panel:transform", (Object)BASIC_TRANSFORM);
        tester.assertModelValue("form:tabs:panel:echo", (Object)false);
    }

    @Test
    public void testAdvancedRule() {
        RuleModel rule = new RuleModel(false);
        rule.setParameter(PARAMETER_NAME);
        rule.setMatch("[\\d]+");
        rule.setParameter(PARAMETER_NAME);
        rule.setTransform(COMPLEX_TRANSFORM);
        rule.setRepeat(Boolean.valueOf(false));
        tester.startPage((Page)new ParamsExtractorRulePage(Optional.of(rule)));
        tester.assertRenderedPage(ParamsExtractorRulePage.class);
        tester.assertComponent("form:tabs:panel", ParamsExtractorRulePage.ComplexRulePanel.class);
        tester.assertModelValue("form:tabs:panel:match", (Object)"[\\d]+");
        tester.assertModelValue("form:tabs:panel:parameter", (Object)PARAMETER_NAME);
        tester.assertModelValue("form:tabs:panel:transform", (Object)COMPLEX_TRANSFORM);
        tester.assertModelValue("form:tabs:panel:repeat", (Object)false);
        tester.assertModelValue("form:tabs:panel:echo", (Object)false);
    }
}

