/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.params.extractor.UrlTransform;

public final class RequestWrapper
extends HttpServletRequestWrapper {
    private final UrlTransform urlTransform;
    private final Map<String, String[]> originalParameters;
    private final String pathInfo;
    private final String servletPath;
    private final Map<String, String[]> parameters;

    public RequestWrapper(UrlTransform urlTransform, HttpServletRequest request) {
        super(request);
        this.urlTransform = urlTransform;
        this.originalParameters = request.getParameterMap();
        Pattern pathsPattern = Pattern.compile("^" + request.getContextPath() + "(/[^?/#]+)(/[^?#]*[^/?#])?(?:/|/?[?#].*)?$");
        Matcher matcher = pathsPattern.matcher(urlTransform.getOriginalRequestUri());
        if (matcher.matches()) {
            this.servletPath = Optional.ofNullable(matcher.group(1)).orElse("");
            this.pathInfo = Optional.ofNullable(matcher.group(2)).orElse("");
        } else {
            this.pathInfo = "";
            this.servletPath = "";
        }
        this.parameters = new HashMap<String, String[]>(super.getParameterMap());
        this.parameters.putAll(urlTransform.getParameters());
    }

    public Map<String, String[]> getOriginalParameters() {
        return this.originalParameters;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getOriginalRequestURI() {
        return this.urlTransform.getOriginalRequestUri();
    }

    public String getRequestURI() {
        return this.urlTransform.getRequestUri();
    }

    public String getQueryString() {
        return this.urlTransform.getQueryString();
    }

    public String getParameter(String name) {
        String[] value = this.parameters.get(name);
        if (value != null) {
            return value[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }
}

