/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.params.extractor;

import java.util.regex.Pattern;
import org.geoserver.params.extractor.Rule;
import org.geoserver.params.extractor.Utils;

public final class RuleBuilder {
    private String id;
    private Boolean activated;
    private Integer position;
    private String match;
    private String parameter;
    private String activation;
    private String transform;
    private Integer remove;
    private String combine;
    private Boolean repeat;
    private Pattern matchPattern;
    private Pattern activationPattern;

    public RuleBuilder copy(Rule other) {
        this.id = other.getId();
        this.activated = other.getActivated();
        this.position = other.getPosition();
        this.matchPattern = this.position != null ? Pattern.compile(String.format("^(?:/[^/]*){%d}(/([^/]+)).*$", this.position)) : null;
        this.match = other.getMatch();
        this.parameter = other.getParameter();
        this.activation = other.getActivation();
        if (this.activation != null) {
            this.activationPattern = Pattern.compile(this.activation);
        }
        this.transform = other.getTransform();
        this.remove = other.getRemove();
        this.combine = other.getCombine();
        return this;
    }

    public RuleBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RuleBuilder withActivated(Boolean activated) {
        this.activated = activated;
        return this;
    }

    public RuleBuilder withPosition(Integer position) {
        if (position != null) {
            this.position = position;
            this.matchPattern = Pattern.compile(String.format("^(?:/[^/]*){%d}(/([^/]+)).*$", position));
        }
        return this;
    }

    public RuleBuilder withMatch(String match) {
        if (match != null) {
            this.match = match;
            this.matchPattern = Pattern.compile(match);
        }
        return this;
    }

    public RuleBuilder withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    public RuleBuilder withActivation(String activation) {
        if (activation != null) {
            this.activationPattern = Pattern.compile(activation);
            this.activation = activation;
        }
        return this;
    }

    public RuleBuilder withRemove(Integer remove) {
        this.remove = remove;
        return this;
    }

    public RuleBuilder withTransform(String transform) {
        this.transform = transform;
        return this;
    }

    public RuleBuilder withCombine(String combine) {
        this.combine = combine;
        return this;
    }

    public RuleBuilder withRepeat(Boolean repeat) {
        if (repeat != null) {
            this.repeat = repeat;
        }
        return this;
    }

    public Rule build() {
        Utils.checkCondition(this.position == null || this.match == null, "Only one of the attributes position and match can be selected.", new Object[0]);
        Utils.checkCondition(this.id != null && !this.id.isEmpty(), "Rule id cannot be NULL or EMPTY.", new Object[0]);
        Utils.checkCondition(this.matchPattern != null, "Both attributes position or match cannot be NULL.", new Object[0]);
        Utils.checkCondition(this.parameter != null && !this.parameter.isEmpty(), "Parameter attribute is mandatory it cannot be NULL or EMPTY.", new Object[0]);
        Utils.checkCondition(this.transform != null && !this.transform.isEmpty(), "Transform attribute is mandatory it cannot be NULL or EMPTY.", new Object[0]);
        return new Rule(this.id, Utils.withDefault(this.activated, true), this.position, this.match, this.activation, this.parameter, this.transform, this.remove, this.combine, Utils.withDefault(this.repeat, false), this.matchPattern, this.activationPattern);
    }
}

