/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.data.CatalogWriter;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.util.IOUtils;
import org.geotools.appschema.resolver.data.SampleDataAccessData;
import org.geotools.appschema.resolver.data.SampleDataAccessFactory;
import org.locationtech.jts.geom.Envelope;

public class SampleDataAccessMockData
extends SystemTestData {
    public static final String DATASTORE_NAME = "datastore";
    public static final String KEY_SRS_HANDLINGS = "srsHandling";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_STYLE = "style";
    public static final String KEY_SRS_NUMBER = "srs";
    public static final String KEY_LL_ENVELOPE = "ll_envelope";
    public static final String KEY_NATIVE_ENVELOPE = "native_envelope";
    static final Envelope DEFAULT_ENVELOPE = new Envelope(-180.0, 180.0, -90.0, 90.0);
    File featureTypes;

    public SampleDataAccessMockData() throws IOException {
        this.data = IOUtils.createRandomDirectory((String)"./target", (String)"sample-data-access-mock", (String)"data");
        this.data.delete();
        this.data.mkdir();
        this.featureTypes = new File(this.data, "featureTypes");
        this.featureTypes.mkdir();
        this.info(DATASTORE_NAME, "gsml", SampleDataAccessData.MAPPEDFEATURE_TYPE_NAME.getLocalPart());
        this.info(DATASTORE_NAME, "gsml", SampleDataAccessData.GEOLOGICUNIT_TYPE_NAME.getLocalPart());
    }

    public File getDataDirectoryRoot() {
        return this.data;
    }

    public boolean isTestDataAvailable() {
        return true;
    }

    public void setUp() throws Exception {
        this.setUpCatalog();
        this.copyTo(MockData.class.getResourceAsStream("services.xml"), "services.xml");
    }

    public void setUpDefault() throws Exception {
    }

    public void tearDown() throws Exception {
        IOUtils.delete((File)this.data);
        this.data = null;
    }

    protected void setUpCatalog() throws IOException {
        CatalogWriter writer = new CatalogWriter();
        writer.dataStores(Map.of(DATASTORE_NAME, SampleDataAccessFactory.PARAMS), Map.of(DATASTORE_NAME, "gsml"), Collections.emptySet());
        writer.coverageStores(new HashMap(), new HashMap(), Collections.emptySet());
        writer.namespaces(Map.of("gsml", "http://www.example.org/sample-data-access/GeoSciML-lite"));
        writer.styles(Collections.emptyMap());
        writer.write(new File(this.data, "catalog.xml"));
    }

    public void copyTo(InputStream input, String location) throws IOException {
        IOUtils.copy((InputStream)input, (File)new File(this.getDataDirectoryRoot(), location));
    }

    public void info(String datastore, String prefix, String type) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_STYLE, "Default");
        params.put(KEY_SRS_HANDLINGS, 2);
        params.put(KEY_ALIAS, null);
        Integer srs = 4326;
        params.put(KEY_SRS_NUMBER, srs);
        File featureTypeDir = new File(this.featureTypes, prefix + "_" + type);
        featureTypeDir.mkdir();
        File info = new File(featureTypeDir, "info.xml");
        info.delete();
        info.createNewFile();
        try (FileWriter writer = new FileWriter(info);){
            String style;
            writer.write("<featureType datastore=\"" + datastore + "\">");
            writer.write("<name>" + type + "</name>");
            if (params.get(KEY_ALIAS) != null) {
                writer.write("<alias>" + params.get(KEY_ALIAS) + "</alias>");
            }
            writer.write("<SRS>" + params.get(KEY_SRS_NUMBER) + "</SRS>");
            writer.write("<SRSHandling>" + params.get(KEY_SRS_HANDLINGS) + "</SRSHandling>");
            writer.write("<title>" + type + "</title>");
            writer.write("<abstract>abstract about " + type + "</abstract>");
            writer.write("<numDecimals value=\"8\"/>");
            writer.write("<keywords>" + type + "</keywords>");
            Envelope llEnvelope = (Envelope)params.get(KEY_LL_ENVELOPE);
            if (llEnvelope == null) {
                llEnvelope = DEFAULT_ENVELOPE;
            }
            writer.write("<latLonBoundingBox dynamic=\"false\" minx=\"" + llEnvelope.getMinX() + "\" miny=\"" + llEnvelope.getMinY() + "\" maxx=\"" + llEnvelope.getMaxX() + "\" maxy=\"" + llEnvelope.getMaxY() + "\"/>");
            Envelope nativeEnvelope = (Envelope)params.get(KEY_NATIVE_ENVELOPE);
            if (nativeEnvelope != null) {
                writer.write("<nativeBBox dynamic=\"false\" minx=\"" + nativeEnvelope.getMinX() + "\" miny=\"" + nativeEnvelope.getMinY() + "\" maxx=\"" + nativeEnvelope.getMaxX() + "\" maxy=\"" + nativeEnvelope.getMaxY() + "\"/>");
            }
            if ((style = (String)params.get(KEY_STYLE)) == null) {
                style = "Default";
            }
            writer.write("<styles default=\"" + style + "\"/>");
            writer.write("</featureType>");
            writer.flush();
        }
    }
}

