/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.SampleDataAccessTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SampleDataAccessWfsTest
extends SampleDataAccessTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("gsml", "http://www.example.org/sample-data-access/GeoSciML-lite");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
    }

    @Test
    public void testGetCapabilities() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetCapabilities&version=1.1.0");
        LOGGER.info("WFS GetCapabilities response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testDescribeFeatureType() throws Exception {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS DescribeFeatureType response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFeature() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFeatureContent() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        XMLAssert.assertXpathEvaluatesTo((String)"GUNTHORPE FORMATION", (String)"//gsml:MappedFeature[@gml:id='mf1']/gml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"mf1.spec", (String)"//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/@gml:id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Gunthorpe specification description", (String)"//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-1.2 52.5 -1.2 52.6 -1.1 52.6 -1.1 52.5 -1.2 52.5", (String)"//gsml:MappedFeature[@gml:id='mf1']/gsml:shape//gml:posList", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"MERCIA MUDSTONE GROUP", (String)"//gsml:MappedFeature[@gml:id='mf2']/gml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"mf2.spec", (String)"//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/@gml:id", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Mercia specification description", (String)"//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gml:description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"-1.3 52.5 -1.3 52.6 -1.2 52.6 -1.2 52.5 -1.3 52.5", (String)"//gsml:MappedFeature[@gml:id='mf2']/gsml:shape//gml:posList", (Document)doc);
    }

    public void assertXpathCount(int count, String xpath, Document doc) throws Exception {
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList nodes = engine.getMatchingNodes(xpath, doc);
        Assert.assertEquals((long)count, (long)nodes.getLength());
    }

    public String prettyString(Document doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.prettyPrint(doc, out);
        return ((Object)out).toString();
    }

    public void prettyPrint(Document doc, OutputStream out) throws Exception {
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.setOutputProperty("indent", "yes");
        tx.transform(new DOMSource(doc), new StreamResult(out));
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }
}

