/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.topojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.geoserver.wms.topojson.TopoGeom;
import org.geoserver.wms.topojson.Topology;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;

public class TopoJSONEncoder {
    private static final TopologyAdapter TOPOLOGY_ADAPTER = new TopologyAdapter();
    private static final GsonBuilder gsonBuilder = new GsonBuilder();

    public void encode(Topology topology, Writer writer) throws IOException {
        Gson gson = gsonBuilder.create();
        gson.toJson((Object)topology, (Appendable)writer);
        writer.flush();
    }

    public static JsonArray serialize(CoordinateSequence coords) {
        JsonArray arc = new JsonArray();
        int size = coords.size();
        if (size > 0) {
            Coordinate buff = new Coordinate();
            coords.getCoordinate(0, buff);
            TopoJSONEncoder.addCoordinate(arc, buff);
            for (int i = 0; i < size; ++i) {
                coords.getCoordinate(i, buff);
                TopoJSONEncoder.addCoordinate(arc, buff);
            }
        }
        return arc;
    }

    public static JsonArray quantize(CoordinateSequence coords, PrecisionModel precisionModel) {
        JsonArray arc = new JsonArray();
        int size = coords.size();
        if (size > 0) {
            Coordinate buff = new Coordinate();
            coords.getCoordinate(0, buff);
            precisionModel.makePrecise(buff);
            TopoJSONEncoder.addCoordinate(arc, buff);
            double lastX = buff.x;
            double lastY = buff.y;
            for (int i = 1; i < size; ++i) {
                coords.getCoordinate(i, buff);
                precisionModel.makePrecise(buff);
                double deltaX = buff.x - lastX;
                double deltaY = buff.y - lastY;
                lastX = buff.x;
                lastY = buff.y;
                buff.x = deltaX;
                buff.y = deltaY;
                precisionModel.makePrecise(buff);
                if (buff.x == 0.0 && buff.y == 0.0) continue;
                TopoJSONEncoder.addCoordinate(arc, buff);
            }
        }
        return arc;
    }

    private static void addCoordinate(JsonArray arc, Coordinate c) {
        JsonArray coord = new JsonArray();
        double x = c.x;
        double y = c.y;
        Number X = x % 1.0 == 0.0 ? (Number)((int)x) : (Number)x;
        Number Y = y % 1.0 == 0.0 ? (Number)((int)y) : (Number)y;
        coord.add((JsonElement)new JsonPrimitive(X));
        coord.add((JsonElement)new JsonPrimitive(Y));
        arc.add((JsonElement)coord);
    }

    static {
        gsonBuilder.registerTypeAdapter(Topology.class, (Object)TOPOLOGY_ADAPTER);
    }

    private static class MultiPolygonEncoder
    extends TopologyEncoder {
        private MultiPolygonEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.MultiPolygon poly = (TopoGeom.MultiPolygon)geom;
            JsonArray polygons = new JsonArray();
            target.add("arcs", (JsonElement)polygons);
            for (TopoGeom.Polygon p : poly.getPolygons()) {
                polygons.add((JsonElement)PolygonEncoder.indexes(p));
            }
        }
    }

    private static class PolygonEncoder
    extends TopologyEncoder {
        private PolygonEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.Polygon poly = (TopoGeom.Polygon)geom;
            target.add("arcs", (JsonElement)PolygonEncoder.indexes(poly));
        }

        public static JsonArray indexes(TopoGeom.Polygon poly) {
            JsonArray arcs = new JsonArray();
            Iterable<TopoGeom.LineString> rings = poly.getRings();
            for (TopoGeom.LineString ring : rings) {
                arcs.add((JsonElement)LineStringEncoder.indexes(ring));
            }
            return arcs;
        }
    }

    private static class MultiLineStringEncoder
    extends TopologyEncoder {
        private MultiLineStringEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.MultiLineString marc = (TopoGeom.MultiLineString)geom;
            JsonArray arcs = new JsonArray();
            target.add("arcs", (JsonElement)arcs);
            for (TopoGeom.LineString arc : marc.getArcs()) {
                arcs.add((JsonElement)LineStringEncoder.indexes(arc));
            }
        }
    }

    private static class LineStringEncoder
    extends TopologyEncoder {
        private LineStringEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.LineString arc = (TopoGeom.LineString)geom;
            target.add("arcs", (JsonElement)LineStringEncoder.indexes(arc));
        }

        public static JsonArray indexes(TopoGeom.LineString arc) {
            JsonArray arcs = new JsonArray();
            for (Integer index : arc.getIndexes()) {
                arcs.add((JsonElement)new JsonPrimitive((Number)index));
            }
            return arcs;
        }
    }

    private static class MultiPointEncoder
    extends TopologyEncoder {
        private MultiPointEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.MultiPoint multipoint = (TopoGeom.MultiPoint)geom;
            JsonArray coordinates = new JsonArray();
            target.add("coordinates", (JsonElement)coordinates);
            Iterable<TopoGeom.Point> points = multipoint.getPoints();
            for (TopoGeom.Point p : points) {
                JsonArray point = new JsonArray();
                coordinates.add((JsonElement)point);
                point.add((JsonElement)new JsonPrimitive((Number)p.getX()));
                point.add((JsonElement)new JsonPrimitive((Number)p.getY()));
            }
        }
    }

    private static class PointEncoder
    extends TopologyEncoder {
        private PointEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.Point point = (TopoGeom.Point)geom;
            JsonArray coordinates = new JsonArray();
            target.add("coordinates", (JsonElement)coordinates);
            coordinates.add((JsonElement)new JsonPrimitive((Number)point.getX()));
            coordinates.add((JsonElement)new JsonPrimitive((Number)point.getY()));
        }
    }

    private static class GeometryCollecitonEncoder
    extends TopologyEncoder {
        private GeometryCollecitonEncoder() {
        }

        @Override
        protected void encodeInternal(TopoGeom geom, JsonObject target) {
            TopoGeom.GeometryColleciton coll = (TopoGeom.GeometryColleciton)geom;
            JsonArray geoms = new JsonArray();
            target.add("geometries", (JsonElement)geoms);
            for (TopoGeom obj : coll.getGeometries()) {
                geoms.add((JsonElement)TopologyEncoder.encode(obj));
            }
        }
    }

    private static abstract class TopologyEncoder {
        private static Map<String, TopologyEncoder> encoders = new HashMap<String, TopologyEncoder>();

        private TopologyEncoder() {
        }

        public static JsonObject encode(TopoGeom geom) {
            JsonObject obj = new JsonObject();
            String geometryType = geom.getGeometryType();
            TopologyEncoder encoder = encoders.get(geometryType);
            encoder.encode(geom, obj);
            return obj;
        }

        public void encode(TopoGeom geom, JsonObject target) {
            JsonObject properties;
            target.addProperty("type", geom.getGeometryType());
            if (geom.getId() != null) {
                target.addProperty("id", geom.getId());
            }
            if ((properties = this.properties(geom.getProperties())) != null) {
                target.add("properties", (JsonElement)properties);
            }
            this.encodeInternal(geom, target);
        }

        protected abstract void encodeInternal(TopoGeom var1, JsonObject var2);

        @Nullable
        private JsonObject properties(Map<String, Object> properties) {
            if (properties.isEmpty()) {
                return null;
            }
            JsonObject props = new JsonObject();
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                JsonObject jsonValue;
                String name = e.getKey();
                Object value = e.getValue();
                if (value instanceof Map) {
                    jsonValue = this.properties((Map)value);
                } else if (value instanceof Boolean) {
                    jsonValue = new JsonPrimitive((Boolean)value);
                } else if (value instanceof Number) {
                    Number n = (Number)value;
                    if (n instanceof Double && n.doubleValue() % 1.0 == 0.0) {
                        n = n.longValue();
                    } else if (n instanceof Float && n.floatValue() % 1.0f == 0.0f) {
                        n = n.intValue();
                    }
                    jsonValue = new JsonPrimitive(n);
                } else {
                    jsonValue = new JsonPrimitive(String.valueOf(value));
                }
                props.add(name, (JsonElement)jsonValue);
            }
            return props;
        }

        static {
            encoders.put("Point", new PointEncoder());
            encoders.put("MultiPoint", new MultiPointEncoder());
            encoders.put("LineString", new LineStringEncoder());
            encoders.put("MultiLineString", new MultiLineStringEncoder());
            encoders.put("Polygon", new PolygonEncoder());
            encoders.put("MultiPolygon", new MultiPolygonEncoder());
            encoders.put("GeometryCollection", new GeometryCollecitonEncoder());
        }
    }

    private static class TopologyAdapter
    implements JsonSerializer<Topology>,
    JsonDeserializer<Topology> {
        private TopologyAdapter() {
        }

        public JsonElement serialize(Topology topology, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            root.addProperty("type", "Topology");
            root.addProperty("count", (Number)topology.getArcs().size());
            AffineTransform transform = topology.getScreenToWorldTransform();
            if (!transform.isIdentity()) {
                this.addTransform(root, transform);
            }
            this.addArcs(root, topology);
            this.addLayers(root, topology.getLayers());
            return root;
        }

        private void addLayers(JsonObject root, Map<String, TopoGeom.GeometryColleciton> layers) {
            JsonObject objects = new JsonObject();
            root.add("objects", (JsonElement)objects);
            for (Map.Entry<String, TopoGeom.GeometryColleciton> e : layers.entrySet()) {
                String name = e.getKey();
                TopoGeom.GeometryColleciton geometries = e.getValue();
                JsonObject layer = TopologyEncoder.encode(geometries);
                objects.add(name, (JsonElement)layer);
            }
        }

        private void addTransform(JsonObject root, AffineTransform transform) {
            if (transform.isIdentity()) {
                return;
            }
            JsonObject tx = new JsonObject();
            JsonArray scale = new JsonArray();
            scale.add((JsonElement)new JsonPrimitive((Number)transform.getScaleX()));
            scale.add((JsonElement)new JsonPrimitive((Number)transform.getScaleY()));
            tx.add("scale", (JsonElement)scale);
            JsonArray translate = new JsonArray();
            translate.add((JsonElement)new JsonPrimitive((Number)transform.getTranslateX()));
            translate.add((JsonElement)new JsonPrimitive((Number)transform.getTranslateY()));
            tx.add("translate", (JsonElement)translate);
            root.add("transform", (JsonElement)tx);
        }

        private void addArcs(JsonObject root, Topology topology) {
            JsonArray arcs = new JsonArray();
            for (LineString arc : topology.getArcs()) {
                JsonArray jsonArc = topology.getScreenToWorldTransform().isIdentity() ? TopoJSONEncoder.serialize(arc.getCoordinateSequence()) : TopoJSONEncoder.quantize(arc.getCoordinateSequence(), arc.getFactory().getPrecisionModel());
                arcs.add((JsonElement)jsonArc);
            }
            root.add("arcs", (JsonElement)arcs);
        }

        public Topology deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
            throw new UnsupportedOperationException();
        }
    }
}

