/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.geojson;

import com.google.common.collect.ImmutableMap;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.geojson.GeoJsonBuilderFactory;
import org.geoserver.wms.geojson.GeoJsonWMSBuilder;
import org.geoserver.wms.map.RawMap;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mockito.Mockito;

public class GeoJsonTileBuilderTest {
    @Test
    public void testGeoJsonWMSBuilder() throws ParseException, IOException {
        GeoJsonBuilderFactory builderFact = new GeoJsonBuilderFactory();
        Rectangle screenSize = new Rectangle(256, 256);
        ReferencedEnvelope mapArea = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Geometry point = this.geom("POINT(1 10)");
        ImmutableMap pointProps = ImmutableMap.of((Object)"name", (Object)"point1");
        Geometry line = this.geom("LINESTRING(0 0, 1 1, 2 2)");
        ImmutableMap lineProps = ImmutableMap.of((Object)"name", (Object)"line1");
        GeoJsonWMSBuilder tileBuilder = builderFact.newBuilder(screenSize, mapArea);
        tileBuilder.addFeature("Points", "unused", "unused", point, (Map)pointProps);
        tileBuilder.addFeature("Lines", "unused", "unused", line, (Map)lineProps);
        WMSMapContent mapContent = (WMSMapContent)Mockito.mock(WMSMapContent.class);
        RawMap map = tileBuilder.build(mapContent);
        String json = this.decode(map);
        Assert.assertEquals((Object)"{\"type\":\"FeatureCollection\",\"totalFeatures\":\"unknown\",\"features\":[{\"type\":\"Feature\",\"id\":\"unused\",\"geometry\":{\"type\":\"Point\",\"coordinates\":[1,10]},\"geometry_name\":\"unused\",\"properties\":{\"name\":\"point1\"}},{\"type\":\"Feature\",\"id\":\"unused\",\"geometry\":{\"type\":\"LineString\",\"coordinates\":[[0,0],[1,1],[2,2]]},\"geometry_name\":\"unused\",\"properties\":{\"name\":\"line1\"}}]}", (Object)json);
    }

    private Geometry geom(String wkt) throws ParseException {
        return new WKTReader().read(wkt);
    }

    private String decode(RawMap map) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        map.writeTo((OutputStream)bos);
        bos.close();
        String out = new String(bos.toByteArray(), StandardCharsets.UTF_8);
        return out;
    }
}

