/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.mapbox;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import no.ecc.vectortile.VectorTileDecoder;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RawMap;
import org.geoserver.wms.mapbox.MapBoxTileBuilder;
import org.geoserver.wms.mapbox.MapBoxTileBuilderFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mockito.Mockito;

public class MapBoxTileBuilderTest {
    private Geometry geom(String wkt) throws ParseException {
        return new WKTReader().read(wkt);
    }

    private ListMultimap<String, VectorTileDecoder.Feature> decode(RawMap map) throws IOException {
        ArrayListMultimap byLayer = ArrayListMultimap.create();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        map.writeTo((OutputStream)bos);
        bos.close();
        VectorTileDecoder decoder = new VectorTileDecoder();
        decoder.setAutoScale(false);
        for (VectorTileDecoder.Feature feat : decoder.decode(bos.toByteArray())) {
            byLayer.put((Object)feat.getLayerName(), (Object)feat);
        }
        return byLayer;
    }

    @Test
    public void testMapBoxTileBuilder() throws Exception {
        MapBoxTileBuilderFactory builderFact = new MapBoxTileBuilderFactory();
        Rectangle screenSize = new Rectangle(256, 256);
        ReferencedEnvelope mapArea = new ReferencedEnvelope();
        MapBoxTileBuilder tileBuilder = builderFact.newBuilder(screenSize, mapArea);
        Geometry point = this.geom("POINT(1 10)");
        ImmutableMap pointProps = ImmutableMap.of((Object)"name", (Object)"point1");
        Geometry line = this.geom("LINESTRING(0 0, 1 1, 2 2)");
        ImmutableMap lineProps = ImmutableMap.of((Object)"name", (Object)"line1");
        tileBuilder.addFeature("Points", "unused", "unused", point, (Map)pointProps);
        tileBuilder.addFeature("Lines", "unused", "unused", line, (Map)lineProps);
        WMSMapContent mapContent = (WMSMapContent)Mockito.mock(WMSMapContent.class);
        RawMap map = tileBuilder.build(mapContent);
        ListMultimap<String, VectorTileDecoder.Feature> features = this.decode(map);
        Assert.assertEquals((long)2L, (long)features.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"Points", (Object)"Lines"), (Object)features.keySet());
        VectorTileDecoder.Feature pointFeature = (VectorTileDecoder.Feature)features.get((Object)"Points").get(0);
        VectorTileDecoder.Feature lineFeature = (VectorTileDecoder.Feature)features.get((Object)"Lines").get(0);
        Assert.assertTrue((boolean)(pointFeature.getGeometry() instanceof Point));
        Assert.assertEquals((Object)point, (Object)pointFeature.getGeometry());
        Assert.assertEquals((Object)pointProps, (Object)pointFeature.getAttributes());
        Assert.assertTrue((boolean)(lineFeature.getGeometry() instanceof LineString));
        Assert.assertEquals((Object)line, (Object)lineFeature.getGeometry());
        Assert.assertEquals((Object)lineProps, (Object)lineFeature.getAttributes());
    }

    @Test
    public void testEncoderClipping() throws Exception {
        MapBoxTileBuilderFactory builderFact = new MapBoxTileBuilderFactory();
        Rectangle screenSize = new Rectangle(256, 256);
        ReferencedEnvelope mapArea = new ReferencedEnvelope();
        MapBoxTileBuilder tileBuilder = builderFact.newBuilder(screenSize, mapArea);
        Geometry line = this.geom("LINESTRING(-100 -100,300 300)");
        ImmutableMap lineProps = ImmutableMap.of((Object)"name", (Object)"line1");
        tileBuilder.addFeature("Lines", "unused", "unused", line, (Map)lineProps);
        WMSMapContent mapContent = (WMSMapContent)Mockito.mock(WMSMapContent.class);
        RawMap map = tileBuilder.build(mapContent);
        ListMultimap<String, VectorTileDecoder.Feature> features = this.decode(map);
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"Lines"), (Object)features.keySet());
        VectorTileDecoder.Feature lineFeature = (VectorTileDecoder.Feature)features.get((Object)"Lines").get(0);
        Assert.assertTrue((boolean)(lineFeature.getGeometry() instanceof LineString));
        Assert.assertEquals((Object)line, (Object)lineFeature.getGeometry());
    }

    @Test
    public void testFeatureIdsWithDigitsAtTheEnd() throws Exception {
        MapBoxTileBuilder tileBuilder = this.tileBuilder(256, 256);
        ImmutableMap lineProps1 = ImmutableMap.of((Object)"name", (Object)"line1");
        ImmutableMap lineProps2 = ImmutableMap.of((Object)"name", (Object)"line2");
        tileBuilder.addFeature("Lines", "Lines.1", "unused", this.geom("LINESTRING(10 10, 20 20)"), (Map)lineProps1);
        tileBuilder.addFeature("Lines", "Lines.27", "unused", this.geom("LINESTRING(50 50, 50 30)"), (Map)lineProps2);
        RawMap map = tileBuilder.build((WMSMapContent)Mockito.mock(WMSMapContent.class));
        ListMultimap<String, VectorTileDecoder.Feature> features = this.decode(map);
        Assert.assertEquals((long)2L, (long)features.size());
        Assert.assertEquals((long)1L, (long)((VectorTileDecoder.Feature)features.get((Object)"Lines").get(0)).getId());
        Assert.assertEquals((long)27L, (long)((VectorTileDecoder.Feature)features.get((Object)"Lines").get(1)).getId());
    }

    @Test
    public void testFeatureIdsWithoutDigits() throws Exception {
        MapBoxTileBuilder tileBuilder = this.tileBuilder(256, 256);
        ImmutableMap lineProps1 = ImmutableMap.of((Object)"name", (Object)"line1");
        ImmutableMap lineProps2 = ImmutableMap.of((Object)"name", (Object)"line2");
        tileBuilder.addFeature("Lines", "an_id", "unused", this.geom("LINESTRING(10 10, 20 20)"), (Map)lineProps1);
        tileBuilder.addFeature("Lines", "another_id", "unused", this.geom("LINESTRING(50 50, 50 30)"), (Map)lineProps2);
        RawMap map = tileBuilder.build((WMSMapContent)Mockito.mock(WMSMapContent.class));
        ListMultimap<String, VectorTileDecoder.Feature> features = this.decode(map);
        Assert.assertEquals((long)2L, (long)features.size());
        Assert.assertEquals((long)0L, (long)((VectorTileDecoder.Feature)features.get((Object)"Lines").get(0)).getId());
        Assert.assertEquals((long)0L, (long)((VectorTileDecoder.Feature)features.get((Object)"Lines").get(1)).getId());
    }

    private MapBoxTileBuilder tileBuilder(int width, int height) {
        MapBoxTileBuilderFactory builderFact = new MapBoxTileBuilderFactory();
        Rectangle screenSize = new Rectangle(width, height);
        ReferencedEnvelope mapArea = new ReferencedEnvelope();
        return builderFact.newBuilder(screenSize, mapArea);
    }
}

