/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import org.geoserver.wms.vector.PipelineBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class ClipRemoveDegenerateTest {
    @Test
    public void testSimple() throws Exception {
        PipelineBuilder.ClipRemoveDegenerateGeometries clip = new PipelineBuilder.ClipRemoveDegenerateGeometries(new Envelope(0.0, 10.0, 0.0, 10.0));
        Geometry result = clip._run(this.fromWKT("LINESTRING(1 1,2 2)"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("LINESTRING(1 1,2 2)"));
        result = clip._run(this.fromWKT("MULTILINESTRING( (1 1,2 2), (5 5,7 7) )"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("MULTILINESTRING( (1 1,2 2), (5 5,7 7) )"));
        result = clip._run(this.fromWKT("POINT(1 1)"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("POINT(1 1)"));
        result = clip._run(this.fromWKT("MULTIPOINT(1 1,2 2 )"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("MULTIPOINT(1 1,2 2 )"));
        result = clip._run(this.fromWKT("POLYGON((1 1,1 2,2 2,2 1,1 1))"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("POLYGON((1 1,1 2,2 2,2 1,1 1))"));
        result = clip._run(this.fromWKT("MULTIPOLYGON(((1 1,1 2,2 2,2 1,1 1)),((4 4,4 5,5 5,5 4, 4 4)) )"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("MULTIPOLYGON(((1 1,1 2,2 2,2 1,1 1)),((4 4,4 5,5 5,5 4, 4 4)) )"));
    }

    @Test
    public void testClipDegenerativeLine() throws Exception {
        PipelineBuilder.ClipRemoveDegenerateGeometries clip = new PipelineBuilder.ClipRemoveDegenerateGeometries(new Envelope(0.0, 10.0, 0.0, 10.0));
        Geometry result = clip._run(this.fromWKT("LINESTRING(-1 -1,0 0)"));
        Assert.assertNull((Object)result);
        result = clip._run(this.fromWKT("LINESTRING(0 0, -10 0, -10 5,0 5)"));
        Assert.assertNull((Object)result);
        result = clip._run(this.fromWKT("LINESTRING (2 2, 4 -2 , 5 0, 6 -2, 7 0)"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("LINESTRING(2 2, 3 0)"));
        result = clip._run(this.fromWKT("LINESTRING (-0.9886673520149238 3.828985034223336, 5.746284581525119 -1.9900134363552608, 11.511403436635396 3.5595869568817347)"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("MULTILINESTRING ((0 2.9747764420824416, 3.4430282894472706 0), (7.813580093078642 0, 10 2.1046845832981296))"));
    }

    @Test
    public void testClipDegenerativePolygon() throws Exception {
        PipelineBuilder.ClipRemoveDegenerateGeometries clip = new PipelineBuilder.ClipRemoveDegenerateGeometries(new Envelope(0.0, 10.0, 0.0, 10.0));
        Geometry result = clip._run(this.fromWKT("POLYGON( (-10 -10, 0 -10, 0 0,-10 0,-10 -10))"));
        Assert.assertNull((Object)result);
        result = clip._run(this.fromWKT("POLYGON( (-10 -10, 10 -10, 10 0,-10 0,-10 -10))"));
        Assert.assertNull((Object)result);
        result = clip._run(this.fromWKT("POLYGON( (-10 -10, 10 -10, 10 0,-10 0,-10 -10))"));
        Assert.assertNull((Object)result);
        result = clip._run(this.fromWKT("POLYGON ((1  -3 , 1 0, 3 0, 3 -1, 5 -1, 5 0, 6 0, 7 -1, 10 -1, 10 0, 12 -3, 1 -3))"));
        Assert.assertNull((Object)result);
        result = clip._run(this.fromWKT("POLYGON ((1 -3, 1 0, 3 0, 3 -1, 5 -1, 5 0, 6 0, 7 -1, 10 -1, 10 0, 10.993923885434695 -1.490885828152043, 11.834681129445318 2.6436334939202886, 8.332506124004496 3.936744265159977, 13.397189978026608 4.313901573438219, 12 -3, 1 -3))"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("POLYGON ((10 3.32105421863856, 8.332506124004496 3.936744265159977, 10 4.060919341031982, 10 3.32105421863856)))"));
        result = clip._run(this.fromWKT("POLYGON ((1 -3, 1 0, 3 0, 3 -1, 5 -1, 5 0, 6 0, 7 -1, 10 -1, 10 0, 10.993923885434695 -1.490885828152043, 11.834681129445318 2.6436334939202886, 8.332506124004496 3.936744265159977, 11.242005359293794 4.744938497184782, 9.03294112509266 6.576845423107674, 12.050199591318599 6.900123115917596, 13.397189978026608 4.313901573438219, 12 -3, 1 -3))"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("MULTIPOLYGON (((10 3.32105421863856, 8.332506124004496 3.936744265159977, 10 4.399937008492062, 10 3.32105421863856)), ((10 5.774894160989392, 9.03294112509266 6.576845423107674, 10 6.680458873990603, 10 5.774894160989392)))"));
    }

    @Test
    public void testClipDegenerativePoint() throws Exception {
        PipelineBuilder.ClipRemoveDegenerateGeometries clip = new PipelineBuilder.ClipRemoveDegenerateGeometries(new Envelope(0.0, 10.0, 0.0, 10.0));
        Geometry result = clip._run(this.fromWKT("MULTIPOINT(1 1, 2 2)"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("MULTIPOINT(1 1, 2 2)"));
    }

    @Test
    public void testClipDegenerativeGC() throws Exception {
        PipelineBuilder.ClipRemoveDegenerateGeometries clip = new PipelineBuilder.ClipRemoveDegenerateGeometries(new Envelope(0.0, 10.0, 0.0, 10.0));
        Geometry result = clip._run(this.fromWKT("GEOMETRYCOLLECTION(POLYGON ((1 -3, 1 0, 3 0, 3 -1, 5 -1, 5 0, 6 0, 7 -1, 10 -1, 10 0, 10.993923885434695 -1.490885828152043, 11.834681129445318 2.6436334939202886, 8.332506124004496 3.936744265159977, 11.242005359293794 4.744938497184782, 9.03294112509266 6.576845423107674, 12.050199591318599 6.900123115917596, 13.397189978026608 4.313901573438219, 12 -3, 1 -3)),POLYGON ((1 -3, 1 0, 3 0, 3 -1, 5 -1, 5 0, 6 0, 7 -1, 10 -1, 10 0, 10.993923885434695 -1.490885828152043, 11.834681129445318 2.6436334939202886, 8.332506124004496 3.936744265159977, 11.242005359293794 4.744938497184782, 9.03294112509266 6.576845423107674, 12.050199591318599 6.900123115917596, 13.397189978026608 4.313901573438219, 12 -3, 1 -3)) )"));
        Assert.assertEquals((Object)result, (Object)this.fromWKT("GEOMETRYCOLLECTION(MULTIPOLYGON (((10 3.32105421863856, 8.332506124004496 3.936744265159977, 10 4.399937008492062, 10 3.32105421863856)), ((10 5.774894160989392, 9.03294112509266 6.576845423107674, 10 6.680458873990603, 10 5.774894160989392))),MULTIPOLYGON (((10 3.32105421863856, 8.332506124004496 3.936744265159977, 10 4.399937008492062, 10 3.32105421863856)), ((10 5.774894160989392, 9.03294112509266 6.576845423107674, 10 6.680458873990603, 10 5.774894160989392))))"));
        result = clip._run(this.fromWKT("GEOMETRYCOLLECTION(LINESTRING(-1 -1,-2 -2),LINESTRING(-1 -1,-2 -2))"));
        Assert.assertNull((Object)result);
    }

    public Geometry fromWKT(String wkt) throws ParseException {
        return new WKTReader().read(wkt);
    }
}

