/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import net.minidev.json.JSONArray;
import no.ecc.vectortile.VectorTileDecoder;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class VectorTilesIntegrationTest
extends WMSTestSupport {
    protected DocumentContext getAsJSONPath(String path, int expectedHttpCode) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        if (!VectorTilesIntegrationTest.isQuietTests()) {
            LOGGER.info(response.getContentAsString());
        }
        Assert.assertEquals((long)expectedHttpCode, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/json"));
        return JsonPath.parse((String)response.getContentAsString());
    }

    @Test
    public void testSimple() throws Exception {
        String request = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&bbox=-1,-1,1,1&width=768&height=330&srs=EPSG:4326&format=application%2Fjson%3Btype%3Dgeojson";
        DocumentContext json = this.getAsJSONPath(request, 200);
        Assert.assertEquals((long)5L, (long)((JSONArray)json.read("$.features", new Predicate[0])).size());
        Assert.assertEquals((long)5L, (long)((JSONArray)json.read("$.features[*].geometry", new Predicate[0])).size());
        Assert.assertEquals((long)3L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Route 5')]", new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Main Street')]", new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Dirt Road by Green Forest')]", new Predicate[0])).size());
    }

    @Test
    public void testSimpleMVT() throws Exception {
        this.checkSimpleMVT("application/vnd.mapbox-vector-tile");
    }

    @Test
    public void testSimpleMVTLegacyMime() throws Exception {
        this.checkSimpleMVT("application/x-protobuf;type=mapbox-vector");
    }

    public void checkSimpleMVT(String mimeType) throws Exception {
        String request = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&bbox=-1,-1,1,1&width=768&height=330&srs=EPSG:4326&format=" + mimeType;
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)response.getContentType());
        byte[] responseBytes = response.getContentAsByteArray();
        VectorTileDecoder decoder = new VectorTileDecoder();
        List featuresList = decoder.decode(responseBytes).asList();
        Assert.assertEquals((long)5L, (long)featuresList.size());
        Assert.assertEquals((long)3L, (long)featuresList.stream().filter(f -> "Route 5".equals(f.getAttributes().get("NAME"))).count());
        Assert.assertEquals((long)1L, (long)featuresList.stream().filter(f -> "Main Street".equals(f.getAttributes().get("NAME"))).count());
        Assert.assertEquals((String)"Extent should be 12288", (long)12288L, (long)((VectorTileDecoder.Feature)featuresList.get(0)).getExtent());
    }

    @Test
    public void testCqlFilter() throws Exception {
        String request = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&bbox=-1,-1,1,1&width=768&height=330&srs=EPSG:4326&CQL_FILTER=NAME='Main Street'&format=application%2Fjson%3Btype%3Dgeojson";
        DocumentContext json = this.getAsJSONPath(request, 200);
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features", new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features[*].geometry", new Predicate[0])).size());
        Assert.assertEquals((long)0L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Route 5')]", new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Main Street')]", new Predicate[0])).size());
        Assert.assertEquals((long)0L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Dirt Road by Green Forest')]", new Predicate[0])).size());
    }

    @Test
    public void testCqlFilterNoMatch() throws Exception {
        String request = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&bbox=-1,-1,1,1&width=768&height=330&srs=EPSG:4326&CQL_FILTER=1=0&format=application/vnd.mapbox-vector-tile";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)response.getContentType());
        byte[] responseBytes = response.getContentAsByteArray();
        VectorTileDecoder decoder = new VectorTileDecoder();
        List featuresList = decoder.decode(responseBytes).asList();
        Assert.assertEquals((long)0L, (long)featuresList.size());
    }

    @Test
    public void testFilterById() throws Exception {
        String request = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&bbox=-1,-1,1,1&width=768&height=330&srs=EPSG:4326&featureId=RoadSegments.1107532045091&format=application%2Fjson%3Btype%3Dgeojson";
        DocumentContext json = this.getAsJSONPath(request, 200);
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features", new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features[*].geometry", new Predicate[0])).size());
        Assert.assertEquals((long)0L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Route 5')]", new Predicate[0])).size());
        Assert.assertEquals((long)0L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Main Street')]", new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((JSONArray)json.read("$.features[?(@.properties.NAME == 'Dirt Road by Green Forest')]", new Predicate[0])).size());
    }
}

