/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector.iterator;

import java.util.Map;
import java.util.NoSuchElementException;
import org.geoserver.wms.vector.VectorTileMapOutputFormatTest;
import org.geoserver.wms.vector.iterator.CoalescingVTIterator;
import org.geoserver.wms.vector.iterator.SimpleVTIterator;
import org.geoserver.wms.vector.iterator.VTFeature;
import org.geoserver.wms.vector.iterator.VTIterator;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.EmptyFeatureCollection;
import org.junit.Assert;
import org.junit.Test;

public class CoalescingVTIteratorTest {
    public static final String STRING_PROP_1_1 = "StringProp1_1";
    public static final String STRING_PROP_1_2 = "StringProp1_2";
    public static final String STRING_PROP_1_3 = "StringProp1_3";
    public static final String P11 = "POINT (1 1)";
    public static final String P22 = "POINT (2 2)";
    public static final String P33 = "POINT (3 3)";
    public static final String ID_POINT_1 = "point1";
    public static final String ID_POINT_2 = "point2";
    public static final String ID_POINT_3 = "point3";
    public static final int INT1000 = 1000;
    public static final int INT2000 = 2000;
    public static final int INT3000 = 3000;
    static final SimpleFeatureType POINT_TYPE;
    static final SimpleFeatureType LINE_TYPE;

    @Test
    public void testEmpty() {
        try (SimpleFeatureIterator fi = new EmptyFeatureCollection(POINT_TYPE).features();
             CoalescingVTIterator vti = new CoalescingVTIterator((VTIterator)new SimpleVTIterator(fi));){
            Assert.assertFalse((boolean)vti.hasNext());
            Assert.assertThrows(NoSuchElementException.class, () -> ((CoalescingVTIterator)vti).next());
        }
    }

    @Test
    public void testNoMerge() throws Exception {
        MemoryDataStore ds = new MemoryDataStore();
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_1, STRING_PROP_1_1, 1000, P11));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_2, STRING_PROP_1_2, 2000, P22));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_3, STRING_PROP_1_3, 3000, P33));
        try (SimpleFeatureIterator fi = ds.getFeatureSource(POINT_TYPE.getTypeName()).getFeatures().features();
             CoalescingVTIterator vti = new CoalescingVTIterator((VTIterator)new SimpleVTIterator(fi));){
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f1 = vti.next();
            Assert.assertEquals((Object)ID_POINT_1, (Object)f1.getFeatureId());
            Assert.assertEquals((Object)P11, (Object)f1.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_1, "ip", 1000), (Object)f1.getProperties());
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f2 = vti.next();
            Assert.assertEquals((Object)ID_POINT_2, (Object)f2.getFeatureId());
            Assert.assertEquals((Object)P22, (Object)f2.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_2, "ip", 2000), (Object)f2.getProperties());
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f3 = vti.next();
            Assert.assertEquals((Object)ID_POINT_3, (Object)f3.getFeatureId());
            Assert.assertEquals((Object)P33, (Object)f3.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_3, "ip", 3000), (Object)f3.getProperties());
            Assert.assertFalse((boolean)vti.hasNext());
            Assert.assertThrows(NoSuchElementException.class, () -> ((CoalescingVTIterator)vti).next());
        }
    }

    @Test
    public void testTailMerge() throws Exception {
        MemoryDataStore ds = new MemoryDataStore();
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_1, STRING_PROP_1_1, 1000, P11));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_2, STRING_PROP_1_2, 2000, P22));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_3, STRING_PROP_1_2, 2000, P33));
        try (SimpleFeatureIterator fi = ds.getFeatureSource(POINT_TYPE.getTypeName()).getFeatures().features();
             CoalescingVTIterator vti = new CoalescingVTIterator((VTIterator)new SimpleVTIterator(fi));){
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f1 = vti.next();
            Assert.assertEquals((Object)ID_POINT_1, (Object)f1.getFeatureId());
            Assert.assertEquals((Object)P11, (Object)f1.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_1, "ip", 1000), (Object)f1.getProperties());
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f2 = vti.next();
            Assert.assertEquals((Object)ID_POINT_2, (Object)f2.getFeatureId());
            Assert.assertEquals((Object)"MULTIPOINT ((2 2), (3 3))", (Object)f2.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_2, "ip", 2000), (Object)f2.getProperties());
            Assert.assertFalse((boolean)vti.hasNext());
            Assert.assertThrows(NoSuchElementException.class, () -> ((CoalescingVTIterator)vti).next());
        }
    }

    @Test
    public void testHeadMerge() throws Exception {
        MemoryDataStore ds = new MemoryDataStore();
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_1, STRING_PROP_1_1, 1000, P11));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_2, STRING_PROP_1_1, 1000, P22));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_3, STRING_PROP_1_3, 3000, P33));
        try (SimpleFeatureIterator fi = ds.getFeatureSource(POINT_TYPE.getTypeName()).getFeatures().features();
             CoalescingVTIterator vti = new CoalescingVTIterator((VTIterator)new SimpleVTIterator(fi));){
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f1 = vti.next();
            Assert.assertEquals((Object)ID_POINT_1, (Object)f1.getFeatureId());
            Assert.assertEquals((Object)"MULTIPOINT ((1 1), (2 2))", (Object)f1.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_1, "ip", 1000), (Object)f1.getProperties());
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f2 = vti.next();
            Assert.assertEquals((Object)ID_POINT_3, (Object)f2.getFeatureId());
            Assert.assertEquals((Object)P33, (Object)f2.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_3, "ip", 3000), (Object)f2.getProperties());
            Assert.assertFalse((boolean)vti.hasNext());
            Assert.assertThrows(NoSuchElementException.class, () -> ((CoalescingVTIterator)vti).next());
        }
    }

    @Test
    public void testMergeAll() throws Exception {
        MemoryDataStore ds = new MemoryDataStore();
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_1, STRING_PROP_1_1, 1000, P11));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_2, STRING_PROP_1_1, 1000, P22));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(POINT_TYPE, ID_POINT_3, STRING_PROP_1_1, 1000, P33));
        try (SimpleFeatureIterator fi = ds.getFeatureSource(POINT_TYPE.getTypeName()).getFeatures().features();
             CoalescingVTIterator vti = new CoalescingVTIterator((VTIterator)new SimpleVTIterator(fi));){
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f = vti.next();
            Assert.assertEquals((Object)ID_POINT_1, (Object)f.getFeatureId());
            Assert.assertEquals((Object)"MULTIPOINT ((1 1), (2 2), (3 3))", (Object)f.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_1, "ip", 1000), (Object)f.getProperties());
            Assert.assertFalse((boolean)vti.hasNext());
            Assert.assertThrows(NoSuchElementException.class, () -> ((CoalescingVTIterator)vti).next());
        }
    }

    @Test
    public void testMergeLines() throws Exception {
        MemoryDataStore ds = new MemoryDataStore();
        ds.addFeature(VectorTileMapOutputFormatTest.feature(LINE_TYPE, "line1", STRING_PROP_1_1, 1000, "LINESTRING(0 0, 1 1)"));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(LINE_TYPE, "line2", STRING_PROP_1_1, 1000, "LINESTRING(1 1, 2 2)"));
        ds.addFeature(VectorTileMapOutputFormatTest.feature(LINE_TYPE, "line3", STRING_PROP_1_1, 1000, "LINESTRING(3 3, 4 4)"));
        try (SimpleFeatureIterator fi = ds.getFeatureSource(LINE_TYPE.getTypeName()).getFeatures().features();
             CoalescingVTIterator vti = new CoalescingVTIterator((VTIterator)new SimpleVTIterator(fi));){
            Assert.assertTrue((boolean)vti.hasNext());
            VTFeature f = vti.next();
            Assert.assertEquals((Object)"line1", (Object)f.getFeatureId());
            Assert.assertEquals((Object)"MULTILINESTRING ((0 0, 1 1, 2 2), (3 3, 4 4))", (Object)f.getGeometry().toText());
            Assert.assertEquals(Map.of("sp", STRING_PROP_1_1, "ip", 1000), (Object)f.getProperties());
            Assert.assertFalse((boolean)vti.hasNext());
            Assert.assertThrows(NoSuchElementException.class, () -> ((CoalescingVTIterator)vti).next());
        }
    }

    static {
        try {
            POINT_TYPE = DataUtilities.createType((String)"points", (String)"sp:String,ip:Integer,geom:Point:srid=4326");
            LINE_TYPE = DataUtilities.createType((String)"lines", (String)"sp:String,ip:Integer,geom:LineString:srid=4326");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

