/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.mapbox;

import com.google.common.collect.ImmutableSet;
import java.awt.Rectangle;
import java.util.Set;
import org.geoserver.wms.mapbox.MapBoxTileBuilder;
import org.geoserver.wms.vector.VectorTileBuilderFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MapBoxTileBuilderFactory
implements VectorTileBuilderFactory {
    public static final String MIME_TYPE = "application/vnd.mapbox-vector-tile";
    public static final String LEGACY_MIME_TYPE = "application/x-protobuf;type=mapbox-vector";
    public static final Set<String> OUTPUT_FORMATS = ImmutableSet.of((Object)"application/vnd.mapbox-vector-tile", (Object)"application/x-protobuf;type=mapbox-vector", (Object)"pbf");

    @Override
    public Set<String> getOutputFormats() {
        return OUTPUT_FORMATS;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public MapBoxTileBuilder newBuilder(Rectangle screenSize, ReferencedEnvelope mapArea) {
        return new MapBoxTileBuilder(screenSize, mapArea);
    }

    @Override
    public boolean shouldOversampleScale() {
        return true;
    }

    @Override
    public int getOversampleX() {
        return 16;
    }

    @Override
    public int getOversampleY() {
        return 16;
    }
}

