/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector.iterator;

import java.util.List;
import java.util.NoSuchElementException;
import org.geoserver.wms.vector.iterator.PushBackVTIterator;
import org.geoserver.wms.vector.iterator.VTFeature;
import org.geoserver.wms.vector.iterator.VTIterator;
import org.geotools.geometry.jts.GeometryCollector;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.operation.linemerge.LineMerger;

public class CoalescingVTIterator
implements VTIterator {
    PushBackVTIterator delegate;
    VTFeature curr;

    public CoalescingVTIterator(VTIterator delegate) {
        this.delegate = new PushBackVTIterator(delegate);
    }

    private void mergeFeatures() {
        if (!this.delegate.hasNext()) {
            return;
        }
        this.curr = this.delegate.next();
        GeometryCollector collector = null;
        while (this.delegate.hasNext()) {
            VTFeature next = this.delegate.next();
            if (this.curr.getProperties().equals(next.getProperties())) {
                if (collector == null) {
                    collector = new GeometryCollector();
                    collector.add(this.curr.getGeometry());
                }
                collector.add(next.getGeometry());
                continue;
            }
            this.delegate.pushBack();
            break;
        }
        if (collector != null) {
            GeometryCollection geometry = collector.collect();
            if (geometry instanceof MultiLineString && geometry.getNumGeometries() > 1) {
                LineMerger merger = new LineMerger();
                merger.add((Geometry)geometry);
                List merged = (List)merger.getMergedLineStrings();
                geometry = geometry.getFactory().createMultiLineString((LineString[])merged.toArray(LineString[]::new));
            }
            this.curr.setGeometry((Geometry)geometry);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.curr != null) {
            return true;
        }
        this.mergeFeatures();
        return this.curr != null;
    }

    @Override
    public VTFeature next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        VTFeature result = this.curr;
        this.curr = null;
        return result;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

