/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.web;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.ogcapi.APIConformance;
import org.geoserver.ogcapi.v1.features.CQL2Conformance;
import org.geoserver.ogcapi.v1.features.ECQLConformance;
import org.geoserver.ogcapi.v1.features.FeatureConformance;
import org.geoserver.ogcapi.web.ThreeStateAjaxCheckBox;
import org.geoserver.web.services.AdminPagePanel;
import org.geoserver.wfs.WFSInfo;

public class FeatureServiceAdminPanel
extends AdminPagePanel {
    public FeatureServiceAdminPanel(String id, IModel<?> info) {
        super(id, info);
        this.featureServiceSettings(info);
        this.cql2Settings(info);
        this.ecqlSettings(info);
    }

    static FeatureConformance features(IModel<?> info) {
        if (info != null && info.getObject() != null && info.getObject() instanceof WFSInfo) {
            return FeatureConformance.configuration((WFSInfo)((WFSInfo)info.getObject()));
        }
        return null;
    }

    static ECQLConformance ecql(IModel<?> info) {
        if (info != null && info.getObject() != null && info.getObject() instanceof WFSInfo) {
            return ECQLConformance.configuration((WFSInfo)((WFSInfo)info.getObject()));
        }
        return null;
    }

    static CQL2Conformance cql2(IModel<?> info) {
        if (info != null && info.getObject() != null && info.getObject() instanceof WFSInfo) {
            return CQL2Conformance.configuration((WFSInfo)((WFSInfo)info.getObject()));
        }
        return null;
    }

    public void onMainFormSubmit() {
        WFSInfo wfsInfo = (WFSInfo)this.getDefaultModel().getObject();
        FeatureConformance features = FeatureConformance.configuration((WFSInfo)wfsInfo);
        CQL2Conformance cql2 = CQL2Conformance.configuration((WFSInfo)wfsInfo);
        ECQLConformance ecql = ECQLConformance.configuration((WFSInfo)wfsInfo);
        if (!features.isEnabled(wfsInfo)) {
            wfsInfo.getMetadata().remove((Object)FeatureConformance.METADATA_KEY);
        }
        if (!cql2.isEnabled(wfsInfo)) {
            wfsInfo.getMetadata().remove((Object)"cql2");
        }
        if (!ecql.isEnabled(wfsInfo)) {
            wfsInfo.getMetadata().remove((Object)"ecql");
        }
    }

    protected CheckBox addConformance(String key, APIConformance conformance, boolean implemented) {
        CheckBox checkBox = this.addConformance(key, conformance, (IModel<Boolean>)(IModel & Serializable)() -> implemented, (IModel<Boolean>)(IModel & Serializable)() -> implemented);
        checkBox.setEnabled(false);
        return checkBox;
    }

    protected CheckBox addConformance(final String key, final APIConformance conformance, IModel<Boolean> booleanModel, IModel<Boolean> enabled) {
        WFSInfo info = (WFSInfo)this.getDefaultModel().getObject();
        boolean stable = conformance.getLevel().isStable();
        boolean endorsed = conformance.getLevel().isEndorsed();
        Label label = new Label(key + "Label", (Serializable)((Object)conformance.getId()));
        label.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)conformance.getId()))});
        label.setOutputMarkupId(true);
        label.setOutputMarkupPlaceholderTag(true);
        label.setVisible(Boolean.TRUE.equals(enabled.getObject()));
        Label level = new Label(key + "Level", (Serializable)((Object)this.level(conformance.getLevel())));
        level.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)this.recommendation(conformance.getLevel())))});
        ThreeStateAjaxCheckBox checkBox = new ThreeStateAjaxCheckBox(key, booleanModel){

            protected void onUpdate(AjaxRequestTarget target) {
                Label uriLabel = (Label)FeatureServiceAdminPanel.this.get(key + "Label");
                Boolean modelValue = this.getModelObject();
                boolean visible = modelValue == null || modelValue != false;
                uriLabel.setVisible(visible);
                uriLabel.setDefaultModelObject((Object)conformance.getId());
                target.add(new Component[]{uriLabel});
            }
        };
        checkBox.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)conformance.getId()))});
        if (info.isCiteCompliant()) {
            level.setEnabled(stable && endorsed);
            label.setEnabled(stable && endorsed);
            checkBox.setEnabled(stable && endorsed);
        } else {
            level.setEnabled(stable);
        }
        this.add(new Component[]{level});
        this.add(new Component[]{checkBox});
        this.add(new Component[]{label});
        return checkBox;
    }

    private String level(APIConformance.Level level) {
        return level.toString().replace('_', ' ');
    }

    private String recommendation(APIConformance.Level level) {
        switch (level) {
            case COMMUNITY_STANDARD: 
            case STANDARD: {
                return "Stable";
            }
            case DRAFT_STANDARD: 
            case COMMUNITY_DRAFT: {
                return "Unstable";
            }
            case RETIRED_STANDARD: {
                return "Deprecated";
            }
        }
        return "Unknown";
    }

    private void featureServiceSettings(IModel<?> info) {
        FeatureConformance featuresInfo = FeatureServiceAdminPanel.features(info);
        this.addConformance("core", FeatureConformance.CORE, true);
        this.addConformance("oas30", FeatureConformance.OAS30, true);
        this.addConformance("html", FeatureConformance.HTML, true);
        this.addConformance("geojson", FeatureConformance.GEOJSON, true);
        this.addConformance("gml321", FeatureConformance.GML321, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "gml321"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).gml321((WFSInfo)info.getObject()));
        this.addConformance("gmlsf0", FeatureConformance.GMLSF0, false);
        this.addConformance("gmlsf2", FeatureConformance.GMLSF2, false);
        this.addConformance("crsByReference", FeatureConformance.CRS_BY_REFERENCE, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "crsByReference"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).crsByReference((WFSInfo)info.getObject()));
        this.addConformance("filter", FeatureConformance.FILTER, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "filter"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).filter((WFSInfo)info.getObject()));
        this.addConformance("featuresFilter", FeatureConformance.FEATURES_FILTER, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "featuresFilter"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).featuresFilter((WFSInfo)info.getObject()));
        this.addConformance("queryables", FeatureConformance.QUERYABLES, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "queryables"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).queryables((WFSInfo)info.getObject()));
        this.addConformance("ids", FeatureConformance.IDS, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "ids"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).ids((WFSInfo)info.getObject()));
        this.addConformance("search", FeatureConformance.SEARCH, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "search"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).search((WFSInfo)info.getObject()));
        this.addConformance("sortBy", FeatureConformance.SORTBY, (IModel<Boolean>)new PropertyModel((Object)featuresInfo, "sortBy"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.features(info).sortBy((WFSInfo)info.getObject()));
    }

    private void ecqlSettings(IModel<?> info) {
        ECQLConformance ecqlInfo = FeatureServiceAdminPanel.ecql(info);
        this.addConformance("ecql", ECQLConformance.ECQL, (IModel<Boolean>)new PropertyModel((Object)ecqlInfo, "ecql"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.ecql(info).ecql((WFSInfo)info.getObject()));
        this.addConformance("ecqlText", ECQLConformance.ECQL_TEXT, (IModel<Boolean>)new PropertyModel((Object)ecqlInfo, "text"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.ecql(info).text((WFSInfo)info.getObject()));
    }

    private void cql2Settings(IModel<?> info) {
        CQL2Conformance cql2Info = FeatureServiceAdminPanel.cql2(info);
        this.addConformance("cql2Text", CQL2Conformance.CQL2_TEXT, (IModel<Boolean>)new PropertyModel((Object)cql2Info, "text"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.cql2(info).text((WFSInfo)info.getObject()));
        this.addConformance("cql2JSON", CQL2Conformance.CQL2_JSON, (IModel<Boolean>)new PropertyModel((Object)cql2Info, "json"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.cql2(info).json((WFSInfo)info.getObject()));
        this.addConformance("cql2Advanced", CQL2Conformance.CQL2_ADVANCED, true);
        this.addConformance("cql2Arithmetic", CQL2Conformance.CQL2_ARITHMETIC, true);
        this.addConformance("cql2Array", CQL2Conformance.CQL2_ARITHMETIC, false);
        this.addConformance("cql2Basic", CQL2Conformance.CQL2_BASIC, true);
        this.addConformance("cql2BasicSpatial", CQL2Conformance.CQL2_BASIC_SPATIAL, true);
        this.addConformance("cql2Functions", CQL2Conformance.CQL2_FUNCTIONS, (IModel<Boolean>)new PropertyModel((Object)cql2Info, "functions"), (IModel<Boolean>)(IModel & Serializable)() -> FeatureServiceAdminPanel.cql2(info).functions((WFSInfo)info.getObject()));
        this.addConformance("cql2Temporal", CQL2Conformance.CQL2_TEMPORAL, false);
        this.addConformance("cql2PropertyProperty", CQL2Conformance.CQL2_PROPERTY_PROPERTY, true);
        this.addConformance("cql2Spatial", CQL2Conformance.CQL2_SPATIAL, true);
    }
}

