/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Page;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.LinkInfo;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.ogcapi.AbstractLinksEditorTest;
import org.junit.Before;

public class OGCLayerConfigTest
extends AbstractLinksEditorTest {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(SystemTestData.LAKES, this.getCatalog());
    }

    private FeatureTypeInfo getLakes() {
        String lakesName = this.getLayerId(SystemTestData.LAKES);
        return (FeatureTypeInfo)this.getCatalog().getResourceByName(lakesName, FeatureTypeInfo.class);
    }

    @Before
    public void setupPage() {
        FeatureTypeInfo lakes = this.getLakes();
        ArrayList<LinkInfoImpl> links = new ArrayList<LinkInfoImpl>();
        this.link = new LinkInfoImpl("enclosure", "application/zip", "http://www.geoserver.org/data/lakes.zip");
        this.link.setTitle("A few very simple lakes");
        this.link.setService("Features");
        links.add(this.link);
        lakes.getMetadata().put("ogcApiLinks", links);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage((ResourceInfo)lakes, false));
        tester.newFormTester("publishedinfo").submit("tabs:tabs-container:tabs:1:link");
    }

    @Override
    protected List<LinkInfo> getLinks() {
        return (List)this.getLakes().getMetadata().get("ogcApiLinks", List.class);
    }

    @Override
    protected String getFormName() {
        return "publishedinfo";
    }
}

