/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.LinkInfo;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.web.admin.GlobalSettingsPage;
import org.geoserver.web.ogcapi.AbstractLinksEditorTest;
import org.geoserver.web.ogcapi.LinkInfoEditor;
import org.junit.Before;

public class OGCSettingsConfigTest
extends AbstractLinksEditorTest {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setupPage() {
        GeoServerInfo gsi = this.getGeoServer().getGlobal();
        SettingsInfo settings = gsi.getSettings();
        ArrayList<LinkInfoImpl> links = new ArrayList<LinkInfoImpl>();
        this.link = new LinkInfoImpl("enclosure", "application/zip", "http://www.geoserver.org/data/dataset.zip");
        this.link.setTitle("The whole dataset published by GeoServer");
        this.link.setService("Features");
        links.add(this.link);
        settings.getMetadata().put("ogcApiLinks", links);
        this.getGeoServer().save(gsi);
        this.login();
        tester.startPage(GlobalSettingsPage.class);
        WebMarkupContainer extensions = (WebMarkupContainer)tester.getLastRenderedPage().get("form:extensions");
        extensions.visitChildren(Component.class, (component, visit) -> {
            if (component instanceof LinkInfoEditor) {
                visit.stop();
                this.EDITOR = component.getPageRelativePath();
                this.EDITOR_FT = this.EDITOR.substring(this.EDITOR.indexOf(":") + 1);
            }
        });
    }

    @Override
    protected List<LinkInfo> getLinks() {
        return (List)this.getGeoServer().getSettings().getMetadata().get("ogcApiLinks", List.class);
    }

    @Override
    protected String getFormName() {
        return "form";
    }
}

