/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.ogcapi;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.LinkInfo;
import org.geoserver.ogcapi.impl.LinkInfoImpl;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

class LinkInfoEditor
extends FormComponentPanel<List<LinkInfo>> {
    static final Logger LOGGER = Logging.getLogger(LinkInfoEditor.class);
    private static final GeoServerDataProvider.Property<LinkInfo> REL = new GeoServerDataProvider.BeanProperty("rel");
    private static final GeoServerDataProvider.Property<LinkInfo> TYPE = new GeoServerDataProvider.BeanProperty("type");
    private static final GeoServerDataProvider.Property<LinkInfo> HREF = new GeoServerDataProvider.BeanProperty("href");
    private static final GeoServerDataProvider.Property<LinkInfo> TITLE = new GeoServerDataProvider.BeanProperty("title");
    private static final GeoServerDataProvider.Property<LinkInfo> SERVICE = new GeoServerDataProvider.BeanProperty("service");
    private static final GeoServerDataProvider.Property<LinkInfo> REMOVE = new GeoServerDataProvider.PropertyPlaceholder("remove");
    private final ReorderableTablePanel<LinkInfo> table;
    private final Component parent;
    private static final LoadableDetachableModel<List<GeoServerDataProvider.Property<LinkInfo>>> propertiesModel = new LoadableDetachableModel<List<GeoServerDataProvider.Property<LinkInfo>>>(){

        protected List<GeoServerDataProvider.Property<LinkInfo>> load() {
            return Arrays.asList(REL, TYPE, HREF, TITLE, SERVICE, REMOVE);
        }
    };

    public LinkInfoEditor(String id, IModel<List<LinkInfo>> links, Component parent) {
        super(id, links);
        this.parent = parent;
        this.add(new Component[]{new AddLinkLink()});
        this.table = new EditorTable((List)links.getObject(), (Component)this);
        this.table.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.table.setPageable(false);
        this.table.setFilterable(false);
        this.add(new Component[]{this.table});
    }

    public void convertInput() {
        List links = this.table.getItems();
        if (links != null && !links.isEmpty()) {
            this.setConvertedInput(links);
        } else {
            this.setConvertedInput(null);
        }
    }

    private List<String> getAPIServices() {
        ApplicationContext ctx = ((GeoServerApplication)this.getApplication()).getApplicationContext();
        Map beans = ctx.getBeansWithAnnotation(APIService.class);
        return beans.values().stream().map(s -> APIDispatcher.getApiServiceAnnotation(s.getClass())).filter(a -> a != null && a.core()).map(a -> a.service()).sorted().collect(Collectors.toList());
    }

    private class AddLinkLink
    extends AjaxLink<Object> {
        public AddLinkLink() {
            super("addLink");
        }

        public void onClick(AjaxRequestTarget target) {
            LinkInfoEditor.this.table.getItems().add(new LinkInfoImpl());
            target.add(new Component[]{LinkInfoEditor.this.parent});
        }
    }

    private static class UpdateModelBehavior
    extends AjaxFormComponentUpdatingBehavior {
        public UpdateModelBehavior() {
            super("blur");
        }

        protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
        }
    }

    private class EditorTable
    extends ReorderableTablePanel<LinkInfo> {
        private final Component targetComponent;

        public EditorTable(List<LinkInfo> attributes, Component targetComponent) {
            super("table", LinkInfo.class, attributes, propertiesModel);
            this.targetComponent = targetComponent;
        }

        protected Component getComponentForProperty(String id, IModel<LinkInfo> itemModel, GeoServerDataProvider.Property<LinkInfo> property) {
            IModel model = property.getModel(itemModel);
            if (property == SERVICE) {
                Fragment f = new Fragment(id, "service", this.getParent());
                DropDownChoice service = new DropDownChoice("service", model, LinkInfoEditor.this.getAPIServices());
                service.add(new Behavior[]{new UpdateModelBehavior()});
                f.add(new Component[]{service});
                return f;
            }
            if (property == REL || property == TYPE) {
                Fragment f = new Fragment(id, "text", this.getParent());
                TextField nameField = new TextField("text", model);
                nameField.add(new Behavior[]{new UpdateModelBehavior()});
                nameField.setRequired(property != SERVICE);
                f.add(new Component[]{nameField});
                return f;
            }
            if (property == HREF || property == TITLE) {
                Fragment f = new Fragment(id, "area", this.getParent());
                TextArea source = new TextArea("area", model);
                source.add(new Behavior[]{new UpdateModelBehavior()});
                source.setRequired(property != TITLE);
                f.add(new Component[]{source});
                return f;
            }
            if (property == REMOVE) {
                final LinkInfo entry = (LinkInfo)itemModel.getObject();
                PackageResourceReference icon = new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/delete.png");
                ImageAjaxLink<Object> link = new ImageAjaxLink<Object>(id, icon){

                    protected void onClick(AjaxRequestTarget target) {
                        EditorTable.this.getItems().remove(entry);
                        target.add(new Component[]{EditorTable.this.targetComponent});
                    }
                };
                return link;
            }
            return null;
        }
    }
}

